"""
A wrapper for the gamma distribution in the scipy.stats module, which
allows you to use the alpha, beta parameterisation.

Copyright (c) 2011 Carl Scheffler <carl.scheffler@gmail.com>

This file is distributed as part of FaceColorModel.

FaceColorModel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License version 3 as
published by the Free Software Foundation.

FaceColorModel is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with FaceColorModel. If not, see <http://www.gnu.org/licenses/>.
"""
from __future__ import division
from scipy.stats import gamma

def scipy_gamma_distribution(alpha, beta, **kwargs):
    kwargs['scale'] = 1/beta
    return gamma(alpha, **kwargs)

def scipy_gamma_samples(alpha, beta, **kwargs):
    kwargs['scale'] = 1/beta
    return gamma.rvs(alpha, **kwargs)
