"""
A simple module for parsing command line arguments.

Copyright (c) 2011 Carl Scheffler <carl.scheffler@gmail.com>

This file is distributed as part of FaceColorModel.

FaceColorModel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License version 3 as
published by the Free Software Foundation.

FaceColorModel is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with FaceColorModel. If not, see <http://www.gnu.org/licenses/>.
"""
def parse(iSpecification, iArguments):
    possibleArgs = dict([(iSpecification[i][1], i) for i in range(len(iSpecification))])
    suppliedArgs = iArguments[1:]

    completedArgs = [] # Entries from possibleArgs that have already been found in suppliedArgs
    nonKeywordArgs = [] # Entries from suppliedArgs that do not appear in possibleArgs (assumed to be non-keyword arguments)
    keywordArgs = {} # 
    while len(suppliedArgs) > 0:
        if suppliedArgs[0] not in possibleArgs:
            if suppliedArgs[0] in completedArgs:
                raise ValueError, 'Error: argument "%s" appears more than once'%suppliedArgs[0]
            nonKeywordArgs.append(suppliedArgs[0])
            del suppliedArgs[0]
            continue

        index = possibleArgs[suppliedArgs[0]]
        spec = iSpecification[index]
        del possibleArgs[suppliedArgs[0]]
        del suppliedArgs[0]
        if len(spec) == 5:
            # key/value pair
            try:
                keywordArgs[spec[0]] = spec[2](suppliedArgs[0])
            except Exception:
                raise ValueError, 'Error while parsing argument "%s"'%spec[1]
            del suppliedArgs[0]
        else:
            # flag
            keywordArgs[spec[0]] = True

    # Assign default values to all arguments not found on command line
    for argument in possibleArgs:
        index = possibleArgs[argument]
        spec = iSpecification[index]
        if len(spec) == 5:
            # key/value pair
            keywordArgs[spec[0]] = spec[3]
        else:
            # flag
            keywordArgs[spec[0]] = False
    return keywordArgs, nonKeywordArgs

def usage(iSpecification, iArguments, outputWidth=80):
    indent = 2 # The number of spaces to leave before each command
               # line entry
    
    output = ["", "Usage: %s accepts the following arguments. Defaults are shown in square brackets."%iArguments[0]]
    while len(output[-1]) > outputWidth:
        pos = output[-1].rfind(" ", 0, outputWidth+1)
        output.append(" "*len("Usage: ") + output[-1][pos+1:])
        output[-2] = output[-2][:pos]
    output.append("")

    columnWidth = 0 # [characters]
    for argument in iSpecification:
        columnWidth = max(columnWidth, len(argument[1]))

    for argument in iSpecification:
        if len(argument) == 5:
            # key/value pair
            default = argument[3]
            description = argument[4]
        else:
            # flag
            default = None
            description = argument[2]
        description = description.split()
        if default is not None:
            description.append("[" + str(default) + "]")

        output.append(" "*indent + "%-*s"%(columnWidth+1, argument[1]))
        for word in description:
            if len(output[-1]) + len(word) + 1 > outputWidth:
                output.append(" "*(indent+columnWidth+1))
            output[-1] += " " + word
    return "\n".join(output) + "\n"
