/*
Copyright (c) 2011 Idiap Research Institute, http://www.idiap.ch/
Written by Carl Scheffler <carl.scheffler@gmail.com>

This file is part of FaceColorModel.

FaceColorModel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License version 3 as
published by the Free Software Foundation.

FaceColorModel is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with FaceColorModel. If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __FACECOLORMODELWRAPPER_H__
#define __FACECOLORMODELWRAPPER_H__

#include <Python.h>
#include "Numeric/arrayobject.h"
#include <cv.h>
#include <string>

#include "FaceColorModel.h"

class FaceColorModelWrapper {
 private:
  FaceColorModel::FaceColorModel* mpFaceColorModel;

 public:
  FaceColorModelWrapper(double iKMrf = 2,
			int iSkinType = FaceColorModel::FCM_CONTINUOUS,
			int iHairType = FaceColorModel::FCM_CONTINUOUS);
  ~FaceColorModelWrapper();
  void adapt_to(CvMat const* ipImageMat);
  PyObject* channel_log_likelihood(CvMat const* ipImageMat);
  void reset_to_prior();
  PyObject* get_color_posterior(const char* ipChannel);
  PyObject* get_class_posterior();
  int get_channel_type(int iChannelIndex);
};

#endif
