"""
Use non-skin images from the Compaq skin database to construct a
Dirichlet prior over the histogram of RGB colors found in non-skin
pixels.
Requires: Compaq skin database at path compaq_database/
Creates:  storage/color_prior_background_discrete.data

Copyright (c) 2011 Idiap Research Institute, http://www.idiap.ch/
Written by Carl Scheffler <carl.scheffler@gmail.com>

This file is part of FaceColorModel.

FaceColorModel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License version 3 as
published by the Free Software Foundation.

FaceColorModel is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with FaceColorModel. If not, see <http://www.gnu.org/licenses/>.
"""
from __future__ import division
from scipy import *
import os, sys
from colorlib import load_image
from polya_distribution import compute_polya_parameter

binCount = 16 # Number of histogram bins along each of the RGB dimensions
              # (for a total of binCount**3 bins)
basePath = 'compaq_database/non-skin-images/'

# Read command line arguments
verbose = ("--quiet" not in sys.argv[1:])

edges = arange(0, 257, 256//binCount)-0.5 # Histogram bin edges
counts = [] # The histogram counts in each image
filenames = os.listdir(basePath)
for fileIndex in range(len(filenames)):
    # Read non-skin image
    filename = filenames[fileIndex]
    image = load_image(basePath + filename)
    if image is None:
        if verbose:
            print "Bad image:", filename
    else:
        # Build histogram of RGB values
        arr = array(image)
        blue  = ravel(arr[:,:,0])
        green = ravel(arr[:,:,1])
        red   = ravel(arr[:,:,2])
        histogram, temp = histogramdd(vstack((red, green, blue)).transpose(),
                                      bins=(edges,)*3, normed=False)
        counts.append(ravel(histogram))

    if verbose and ((fileIndex+1) % 1000 == 0):
        print fileIndex+1, '/', len(filenames)

if verbose:
    print "Computing Dirichlet prior from RGB histogram counts..."
alpha = compute_polya_parameter(array(counts), verbose=verbose)

if verbose:
    print "Saving..."
with open("storage/color_prior_background_discrete.data", "wb") as fp:
    fp.write(alpha.data)
