"""
Copyright (c) 2011 Idiap Research Institute, http://www.idiap.ch/
Written by Carl Scheffler <carl.scheffler@gmail.com>

This file is part of FaceColorModel.

FaceColorModel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License version 3 as
published by the Free Software Foundation.

FaceColorModel is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with FaceColorModel. If not, see <http://www.gnu.org/licenses/>.
"""
from __future__ import division
from scipy import *
import pylab

with open('results_mrf.txt','rt') as fp:
    text = fp.read()
exec text

styles = ['bo-', 'rv-']

LATEX_PLOT = False
if LATEX_PLOT:
    LATEX_FIGURE_FACTOR = 0.4 # [1]

    LATEX_TEXT_WIDTH = 367.32089 # [pt]
    LATEX_FIGURE_WIDTH = LATEX_FIGURE_FACTOR * LATEX_TEXT_WIDTH # [pt]
    LATEX_PT_PER_INCH = 72.27 # [pt/inch]

    FIGURE_WIDTH = LATEX_FIGURE_WIDTH/LATEX_PT_PER_INCH
    GOLDEN_RATIO = (sqrt(5)-1)/2

    rc_params = {
        'figure.figsize': (FIGURE_WIDTH, 0.66*FIGURE_WIDTH),
        'axes.labelsize': 10,
        'text.fontsize': 10,
        'font.size': 8,
        'legend.fontsize': 8,
        'xtick.labelsize': 8,
        'ytick.labelsize': 8,
        'figure.subplot.bottom': 0.11,
        'figure.subplot.top': 0.96,
        'figure.subplot.left': 0.1,
        'figure.subplot.right': 0.98,
        'text.usetex': True,
        'lines.linewidth': 1*LATEX_FIGURE_FACTOR,
        'lines.markersize': 6*LATEX_FIGURE_FACTOR,
    }
    pylab.rcParams.update(rc_params)
else:
    rc_params = {
        'axes.labelsize': 10,
        'text.fontsize': 10,
        'font.size': 8,
        'legend.fontsize': 8,
        'xtick.labelsize': 8,
        'ytick.labelsize': 8,
        'text.usetex': True,
    }
    pylab.rcParams.update(rc_params)
    
count = 0
for key in results:
    pylab.plot(results[key], styles[count], label=key)
    count += 1
pylab.xticks(range(len(results[key])))
pylab.xlabel(r'$k_{\textrm{MRF}}$')
pylab.ylabel('accuracy')
pylab.legend(loc=4)
if LATEX_PLOT:
    pylab.savefig('figures/plot_mrf_accuracy.pdf')
pylab.show()
