#ifndef IPCV_MULTI_IMAGE_INC
#define IPCV_MULTI_IMAGE_INC

#include "ip_MultiImage.h"
#include "ipcv_Image.h"

namespace ImageProcessing {

#define  m_cMaxNbOfBands   10

  //-----
  
  /** 
   
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  //===================================================
  //
  //    class         ipcv_MultiImage
  //
  //    Base virtual class for representation
  //    of set of images with different sizes 
  //
  //    1/05/2002:
  //    
  //
  //===================================================

  //====================================================
  //
  //  Implementation of ip_MultiImage using the opencv
  //     implementation of ip_Image.
  //
  //
  //  Added functions :
  //    -- iplImages() : return an array of pointers to 
  //                     the iplImages forming the 
  //                     differents bands.
  //    -- refresh() :   to call after each use of  the 
  //                     iplImages that can modify the 
  //                     image size.
  //
  //====================================================
  template<class Type>
    class  ipcv_MultiImage :
    virtual public ip_MultiImage<Type> {
    //    const int m_cMaxNbOfBands;

    private: // to hold an array of pointers to
    // IplImages
    IplImage    **m_pIplImages;
    int           m_iSizeOfArray;

    public:
    ipcv_MultiImage() : ip_MultiImage<Type>() {
      allocatePtrOnIplImages(0);
    };

    ipcv_MultiImage(int nbbands): ip_MultiImage<Type>(){ 
      allocateMem(nbbands,0,0);
      allocatePtrOnIplImages(nbbands);
    };

    ipcv_MultiImage(int nbbands,int nbli,int nbco): ip_MultiImage<Type>(){
      allocateMem(nbbands,nbli,nbco); 
      allocatePtrOnIplImages(nbbands);
    };
 
    ipcv_MultiImage(int nbbands,int *nbli,int *nbco): ip_MultiImage<Type>(){
      allocateMem(nbbands,nbli,nbco);
      allocatePtrOnIplImages(nbbands);
    };
    
    //---------------- 
    void allocatePtrOnIplImages(int n){
      if(n>m_cMaxNbOfBands)
	m_iSizeOfArray=n;
      else m_iSizeOfArray=m_cMaxNbOfBands;
      if(m_iSizeOfArray>0) 
	m_pIplImages= new IplImage * [m_iSizeOfArray];
    }

    void deAllocatePtrOnIplImages(){
      if(m_iSizeOfArray>0) 
	delete [] m_pIplImages;
    }

    //---------------- 
    ip_Image<Type> * newIpImage(){
      return new ipcv_Image<Type> (0,0);
    }

    //---------------
    // return the table of arrays of IPL_Images 
    IplImage ** iplImages(){
      int i;
      if(nbBands()>m_iSizeOfArray){
	deAllocatePtrOnIplImages();
	allocatePtrOnIplImages(nbBands());
      }
      for(i=0;i<nbBands();i++){
	ipcv_Image<Type> * p_Ima=(ipcv_Image<Type> *)getIpImage(i);
	m_pIplImages[i]=p_Ima->m_pImage;
      }
      return m_pIplImages;
    }
    //---------------
    void refresh(){
      int i;
      for(i=0;i<nbBands();i++){
	ipcv_Image<Type> * p_Ima=(ipcv_Image<Type> *)getIpImage(i);
	p_Ima->refresh();
      }
    }

    //---------------
    virtual ~ipcv_MultiImage(){ deAllocatePtrOnIplImages(); }

  };

   
}

#endif
