#ifndef IP_SHAPE_INC
#define IP_SHAPE_INC

#include "general.h"
#include "ip_PixelAndPoint.h"
#include "ip_Image.h"
#include "ip_ColorDef.h"
#include "ip_DrawFunctions.h"



namespace ImageProcessing {

//-----

/** Provides the interface for "parameterized" primal shapes:
    to start with: bounding boxes and ellipses.   

    @author Jean-Marc Odobez (Jean-Marc.Odobez@idiap.ch)
    @author Daniel Gatica-Perez (gatica@idiap.ch)
*/


  class ip_Shape
  {
    public:
      
    //member functions 

    //-----
    ip_Shape();

    //-----
    virtual void init(void);

    //-----
    virtual void samplePoints(ip_Point *pPointList, int NumberOfPoints)=0;

    //----- 
    virtual void computeNormalToPoint(ip_Point *pPoint, ip_Point *pNormal)=0;

    //----- 
    virtual void computeNormalVectors(ip_Point *pPointList, 
				      ip_Point *pNormalList,
				      int NumberOfPoints)=0;

    //----- for shapes parameterized by angle
    virtual void computeNormalToPoint(ip_Point *pNormal, real angle)=0;

    //----- 
    virtual void computeNormalVectors(ip_Point *pNormalList,
				      int NumberOfPoints)=0;

    //---- for centering purposes
    virtual void translate(int dep_co,int dep_li)=0;	

    //----- 
    virtual void draw(ip_Point *pPointList,
		      int NumberOfPoints,
		      ip_Image<ip_ColorElement8u> & Ima,
		      ip_ColorElement8u color)=0;

    //----- 
    virtual void draw(ip_Point *pPointList,
		      int NumberOfPoints,
		      ip_Image<ip_ColorElement8u> *pImage,
		      ip_ColorElement8u color)=0;

    //----- 
    virtual bool insideEnough(int rows, int cols)=0;

    //-----
    virtual ~ip_Shape();

  };

}

#endif // IP_SHAPE_INC
