#ifndef IP_PLANAR_TRANSLATION_SCALING2_HH
#define IP_PLANAR_TRANSLATION_SCALING2_HH


#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <iomanip.h>

#include "ip_PlanarTransform.h" // for the definition of real

namespace ImageProcessing  {
  
  /** 
      Basic representation for 2D Translation +  scaling in X and Y.
      
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  
  /*
      xp = Tx + sx * dx
      yp = Ty + sy * dy

      image_point    = (xp,yp)
      initial_point  = (x,y)
      dx = x - origin.x
      dy = y - origin.y

      Tx = params[0];
      Ty = params[1];
      sx  = params[2];  
      sy  = params[3];  

      Reminder : x axis = column axis , y axis = line axis
  */

  //============================================================

  class  ip_PlanarTranslationScaling2 :
    virtual public ip_PlanarTransform
    {
    private:
      real *m_pTx,*m_pTy,*m_pScaleX,*m_pScaleY;

    public:
      //-------- 
      ip_PlanarTranslationScaling2();

      //-------- 
      ip_PlanarTranslationScaling2(real *_params);

      //-------- 
      virtual ip_PlanarTransformModel  planarModel();

      //------------------------- 
      //- init to the null motion (identity transform)
      virtual   void  setIdentity();

      //--------
      virtual   void  changeOrigin(ip_Point new_origin);

      //--------
      // x = column number, y line number
      inline virtual ip_Point   imageReal(double x, double y){
	real dx=x-m_cOrigin.m_rX,dy=y-m_cOrigin.m_rY;
	return ip_Point(*m_pTx+*m_pScaleX*dx,*m_pTy+*m_pScaleY*dy);
      }

      //-------   dep =  displacement
      //  x = column number, y line number
      inline virtual ip_Vector depReal(real x, real y){
	real dx=x-m_cOrigin.m_rX,dy=y-m_cOrigin.m_rY;
	return ip_Point(*m_pTx+*m_pScaleX*dx-x,*m_pTy+*m_pScaleY*dy-y);
      }

      //-------
      virtual void display(char * msg="");
  
      //-------
      virtual ~ip_PlanarTranslationScaling2();

};

}

#endif  // ip_PLANAR_TRANSLATION_SCALING2_HH
