#ifndef IP_PLANAR_TRANSLATION_HH
#define IP_PLANAR_TRANSLATION_HH


#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <iomanip.h>

#include "ip_PlanarTransform.h" // for the definition of real

namespace ImageProcessing  {
  
  /** 
      Basic representation for 2D Translation.
      
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  
  /*
      xp = Tx + x
      yp = Ty + y

      image_point    = (xp,yp)
      initial_point  = (x,y)

      Tx = params[0];
      Ty = params[1];
      
      Reminder : x axis = column axis , y axis = line axis
  */

  //============================================================

  class  ip_PlanarTranslation :
    virtual public ip_PlanarTransform
    {
    public:
      //-------- 
      ip_PlanarTranslation();

      //-------- 
      ip_PlanarTranslation(real *_params);

      //-------- 
      virtual ip_PlanarTransformModel  planarModel();

      //------------------------- 
      //- init to the null motion (identity transform)
      virtual   void  setIdentity();

      //--------
      virtual   void  changeOrigin(ip_Point new_origin);

      //--------
      // x = column number, y line number
      inline virtual ip_Point   imageReal(double x, double y){
	return ip_Point((real)(x+m_pParams[0]),(real)(y+m_pParams[1]));
      }

      //-------   dep =  displacement
      //  x = column number, y line number
      inline virtual ip_Vector depReal(real x, real y){
	return ip_Point(m_pParams[0],m_pParams[1]);
      }


      //-------
      virtual void display(char * msg="");
  
      //-------
      virtual ~ip_PlanarTranslation();
      
    };

}

#endif  // ip_PLANAR_TRANSLATION_HH
