#include "ip_PlanarTransform.h" 

namespace ImageProcessing  {
  
  /** 
      Basic representation for 2D planar transform 
      
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  
  /*
      Basic representation for planar transform

      pp     =  f(p,origin)
      dep(p) =  pp-p;

      p     : initial point
      pp    : image point
      dep(p): displacement at point p

    
  */

  //============================================================

  //-------- 
  ip_PlanarTransform::ip_PlanarTransform() : m_pParams(NULL),
					     m_cOrigin((real)0.,(real)0.), 
					     m_iStepRead(1),m_iNbParams(0) { 
  } 

  //-------- 
  int    ip_PlanarTransform::nbParams(){
    return m_iNbParams; 
  }

  //----- dgp
  real * ip_PlanarTransform::getPtrToParams(void)
  {
    return m_pParams; 
  }


  //-------- 
  void  ip_PlanarTransform::getParams(real * _Params,int StepWrite){
    int i; 
    for (i=0;i<m_iNbParams;i++){
      *_Params=m_pParams[i];
      _Params += StepWrite;
    }
  }
  

  //------------------
  // Add a translation
  //  Before translate : pp    = fb(p,origin)
  //  after  translate : newpp = fa(p,origin) = fb(p,origin)+dep
  // dep=(depx,depy)
  void  ip_PlanarTransform::translate(real depx,real depy){
    m_pParams[0] += depx;
    m_pParams[1] += depy;
  }

  //-------- 
  void  ip_PlanarTransform::setOrigin(ip_Point new_origin){
    m_cOrigin=new_origin;
  }

  //-------
  ip_PlanarTransform::~ip_PlanarTransform() {}
      
}

