#include "general.h"
#include "ip_PixelAndPoint.h"
#include "ip_LineSegment.h"
#include "ip_DrawFunctions.h"


namespace ImageProcessing {

  //----- 
  ip_LineSegment::ip_LineSegment()
  {
    m_pFeatures = NULL;
  }
  

  //----
  ip_LineSegment::ip_LineSegment(real xStart, real yStart, real xEnd,
				 real yEnd, int numberOfPoints)
  {
    m_pFeatures = NULL;
    init(xStart, yStart, xEnd, yEnd, numberOfPoints);
  }
  

  //----
  ip_LineSegment::ip_LineSegment(real xCentroid, real yCentroid, real xNormal,
				 real yNormal, real length, int numberOfPoints)
  {
    m_pFeatures = NULL;
    init(xCentroid, yCentroid, xNormal, yNormal, length, numberOfPoints);
  }


  //----
  ip_LineSegment::ip_LineSegment(ip_Point *pCentroid, ip_Point *pNormal,
				 real length, int numberOfPoints)
  {    
    m_pFeatures = NULL;
    init(pCentroid, pNormal, length, numberOfPoints);
  }


  //----
  void ip_LineSegment::init(real xStart, real yStart, real xEnd,
			    real yEnd, int numberOfPoints)
  {
    m_StartPoint.m_rX = xStart; 
    m_StartPoint.m_rY = yStart;
    m_EndPoint.m_rX = xEnd; 
    m_EndPoint.m_rY = yEnd;
    m_iNumberOfPoints = numberOfPoints;
    m_dLength = sqrt( (xStart-xEnd)*(xStart-xEnd) + 
		      (yStart-yEnd)*(yStart-yEnd) );
    m_Normal.m_rX = (xEnd-xStart)/m_dLength;
    m_Normal.m_rY = (yEnd-yStart)/m_dLength;
    if(m_pFeatures==NULL)
      m_pFeatures = new ip_Point[m_iNumberOfPoints];
    m_iNumberOfFeatures = 0;
  }

  //----  
  void ip_LineSegment::init(real xCentroid, real yCentroid, real xNormal,
			    real yNormal, real length, int numberOfPoints)
  {
    m_dLength = length;
    m_iNumberOfPoints = numberOfPoints;

    //make sure the normal vector is unitary
    real l = sqrt( xNormal*xNormal + yNormal*yNormal );
    xNormal = xNormal/l;
    yNormal = yNormal/l;
    m_StartPoint.m_rX = xCentroid + xNormal*length/2; 
    m_StartPoint.m_rY = yCentroid + yNormal*length/2;
    m_EndPoint.m_rX = xCentroid - xNormal*length/2; 
    m_EndPoint.m_rY = yCentroid - yNormal*length/2;
    m_Normal.m_rX = xNormal;
    m_Normal.m_rY = yNormal;
    if(m_pFeatures==NULL)
      m_pFeatures = new ip_Point[m_iNumberOfPoints];
    m_iNumberOfFeatures = 0;
  }


  //---- StartPoint is out of the curve, EndPoint is towards the ellipse
  void ip_LineSegment::init(ip_Point *pCentroid, ip_Point *pNormal,
			     real length, int numberOfPoints)
  {
    m_dLength = length;
    m_iNumberOfPoints = numberOfPoints;

    //make sure the normal vector is unitary
    real l = sqrt(pNormal->m_rX*pNormal->m_rX + pNormal->m_rY*pNormal->m_rY);
    m_Normal.m_rX = pNormal->m_rX/l;
    m_Normal.m_rY = pNormal->m_rY/l;
    m_StartPoint.m_rX = pCentroid->m_rX + m_Normal.m_rX*length/2; 
    m_StartPoint.m_rY = pCentroid->m_rY + m_Normal.m_rY*length/2;
    m_EndPoint.m_rX = pCentroid->m_rX - m_Normal.m_rX*length/2; 
    m_EndPoint.m_rY = pCentroid->m_rY - m_Normal.m_rY*length/2;
    if(m_pFeatures==NULL)
      m_pFeatures = new ip_Point[m_iNumberOfPoints];
    m_iNumberOfFeatures = 0;
  }


  //---- limits the lines to be inside image
  //---- StartPoint is out of the curve, EndPoint is towards the ellipse
  void ip_LineSegment::init(ip_Point *pCentroid, ip_Point *pNormal,
			    real length, int numberOfPoints, int rows, int cols)
  {

   // compute normal vector, make sure it's unitary
    real l = sqrt(pNormal->m_rX*pNormal->m_rX + pNormal->m_rY*pNormal->m_rY);
    m_Normal.m_rX = pNormal->m_rX/l;
    m_Normal.m_rY = pNormal->m_rY/l;

    real ll = length;
    m_StartPoint.m_rX = pCentroid->m_rX + m_Normal.m_rX * ll/2; 
    m_StartPoint.m_rY = pCentroid->m_rY + m_Normal.m_rY * ll/2;
	 m_EndPoint.m_rX = pCentroid->m_rX - m_Normal.m_rX * ll/2; 
	 m_EndPoint.m_rY = pCentroid->m_rY - m_Normal.m_rY * ll/2;

   //reduce size
	 // JMO??  why only starting point, and why reduce length on both side ?
	 while( (ip_inImage(m_StartPoint,rows-2,cols-2) == false||ip_inImage(m_EndPoint,rows-2,cols-2) == false ) && ll > 2.0)
    {
      ll = ll-2.;
      m_StartPoint.m_rX = pCentroid->m_rX + m_Normal.m_rX * ll/2; 
      m_StartPoint.m_rY = pCentroid->m_rY + m_Normal.m_rY * ll/2;
		m_EndPoint.m_rX = pCentroid->m_rX - m_Normal.m_rX * ll/2; 
		m_EndPoint.m_rY = pCentroid->m_rY - m_Normal.m_rY * ll/2;
    }

    //m_StartPoint.m_rX = pCentroid->m_rX + m_Normal.m_rX * ll/2; 
    //m_StartPoint.m_rY = pCentroid->m_rY + m_Normal.m_rY * ll/2;
	 //		m_EndPoint.m_rX = pCentroid->m_rX - m_Normal.m_rX * ll/2; 
	 //	m_EndPoint.m_rY = pCentroid->m_rY - m_Normal.m_rY * ll/2;

	 if(ll<=2.) ll=0.;
	 

    m_dLength = ll;

    if(ll != length)
      m_iNumberOfPoints = (int)ll;
    else
      m_iNumberOfPoints = numberOfPoints;


    /*    printf("centroid: %f %f start: %f %f end: %f %f length: %f Number of points %d\n", 
	   pCentroid->m_rX,pCentroid->m_rY,
	   m_StartPoint.m_rX, m_StartPoint.m_rY, 
	   m_EndPoint.m_rX, m_EndPoint.m_rY, m_dLength,m_iNumberOfPoints);
    */

    //for now still keep the same number of points: this might be wrong later
    if(m_pFeatures==NULL){
      m_pFeatures = new ip_Point[m_iNumberOfPoints];
    }
    m_iNumberOfFeatures = 0;

  }


  //-----
  void ip_LineSegment::freeMemory(void)
  {
    if(m_pFeatures!=NULL)
    {
      delete[] m_pFeatures;
      m_pFeatures = NULL;
    }
  }


}









