#include "general.h"
#include "StringClass.h"
#include "ip_FileName.h"
#include <ctype.h>

namespace ImageProcessing {

  //-----
  
  /** 
   
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  //===================================================
  //
  //
  //===================================================

  //-----------
  ip_FileName::ip_FileName(){ 
  };
  
  //-----------
  ip_FileName::ip_FileName(char * OneName){
    chaine one(OneName);
    int l,d;

    m_cExtension=suffixe_ch(one);
    l=longueur_ch(one)-longueur_ch(m_cExtension);
    one=debut_ch(one,l);
    d=l;

    // looking for directory
    l=d-1;
    while(d>0 && one.s[d-1] !='/')
      d--;
    m_cBaseName=milieu_ch(one,d,l);
    if(d==0){
	  m_cDirectory=chaine("./");
    }
    else
      m_cDirectory=debut_ch(one,d);
  }
  
  //-----------
  ip_FileName::ip_FileName(chaine &dir, chaine &base, chaine & ext) :
    m_cDirectory(dir), m_cBaseName(base),
    m_cExtension(ext) {
  }

  //-----------
  char * ip_FileName::fullName(){
    m_cFullName=m_cDirectory+m_cBaseName+m_cExtension;
    return (char *)m_cFullName.s;
  }
  
  //-----------
  void ip_FileName::display(FILE *f){
    fprintf(f,"Dir = >%s<   Name = >%s<  Extension = >%s< \n",
	    m_cDirectory.s,m_cBaseName.s,m_cExtension.s);
  }

  //-----------
  ip_FileName::~ip_FileName(){};
  

}
