#ifndef IP_ELLIPSE_INC
#define IP_ELLIPSE_INC


#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <iomanip.h>

#include "general.h"
#include "ip_Image.h"
#include "ip_ColorDef.h"
#include "ip_Shape.h"
#include "ip_PixelAndPoint.h"
#include "ip_LineSegment.h"

namespace ImageProcessing {

//-----

/** Provides the interface for a parameterized ellipse
    with arbitrary orientation angle.
    
    (x-x_o)^2    (y-y_o)^2
    ---------- + ---------  = 1
    (axis_x)^2   (axis_y)^2

    @author Jean-Marc Odobez (Jean-Marc.Odobez@idiap.ch)
    @author Daniel Gatica-Perez (gatica@idiap.ch)
*/

  /*
    the ellipse is defined by the following parameters:
    
    - its centroid
    - its major and minor semi-axis
    - its orientation angle

    only the most basic functions are defined here.    

    For planar transformation, another representation is
    more convenient: one that keeps the 4 points that
    intersect the ellipse and the two axes, stored in
    pExtremePoints.

   */


  class ip_Ellipse : public ip_Shape
  {
    public:      

    //members

    ip_Point *m_pCentroid;
    ip_Point *m_pSemiAxis;
    real m_dAngle;
    ip_Point *m_pExtremePoints;              //the 4 points on the semiaxes.


    //member functions 

    //-----
    ip_Ellipse();

    //-----
    ip_Ellipse(real centroidX, real centroidY, real semiAxisX,
		      real semiAxisY, real angle);

    //-----
    ip_Ellipse(real *pPars);

    //-----
    // copy constructor
    ip_Ellipse(const ip_Ellipse & ellipse);

    //-----
    virtual void init(real centroidX, real centroidY, real semiAxisX,
		      real semiAxisY, real angle);
    //-----
    virtual void init(real *pPars);

    //-----
    virtual void init(ip_Ellipse *pE);

    //-----
    virtual ip_Ellipse & operator=(const ip_Ellipse & ellipse);
    


    //----
    virtual void getExtremePointsFromPars(void);

    //----
    virtual void getParsFromExtremePoints(void);
   
    //----- inherited from ip_Shape
    virtual void samplePoints(ip_Point *pPointList, int NumberOfPoints);

    //----- inherited from ip_Shape
    //----- original version: vector between centroid and point: no normal 
    virtual void computeNormalToPoint(ip_Point *pPoint, ip_Point *pNormal);

    //----- inherited from ip_Shape
    //----- correct version: normal vector
    virtual void computeNormalToPoint(ip_Point *pNormal, real angle);

    //----- inherited from ip_Shape
    //----- original version: vector between centroid and point: no normal
    virtual void computeNormalVectors(ip_Point *pPointList, 
				      ip_Point *pNormalList,
				      int NumberOfPoints);
 
    //----- inherited from ip_Shape
    //----- correct version
    virtual void computeNormalVectors(ip_Point *pNormalList,
				      int NumberOfPoints);

    //---- inherited from ip_Shape
    virtual void translate(int dep_co,int dep_li);

    virtual void translateScale(int dep_co,int dep_li, real scale);

    //----- inherited from ip_Shape
    virtual void draw(ip_Point *pPointList,
		      int NumberOfPoints,
		      ip_Image<ip_ColorElement8u> & Image,
		      ip_ColorElement8u color);

    //----- inherited from ip_Shape
    virtual void draw(ip_Point *pPointList,
		      int NumberOfPoints,
		      ip_Image<ip_ColorElement8u> *pImage,
		      ip_ColorElement8u color);

    //----- 
    virtual bool insideEnough(int rows, int cols);

    //-----
    virtual void displayPars(void);

    //-----
    virtual void freeMemory(void);
    
    //-----
    virtual ~ip_Ellipse()
    {freeMemory(); printf("out ellipse \n");}

  };


}

#endif // IP_ELLIPSE_INC




















