// ************************************************************************
// ioascii.h
//
// version
// ************************************************************************



#ifndef IOASCII_HH
#define IOASCII_HH

#include "macros.h"
#include <ctype.h>       // for isspace()
#include <iostream.h>

/* 
==============================================
    To make the reading of parameters from ascii files easiers

    Most of the procedures are intended to read an element 
    from the begining of the line, and to eliminate the remaining
    of the line.
==============================================
*/

//=============================================
// Output a value and the corresponding comment
//=============================================
template<class type>
inline void Mput(ostream & Out, type & T,char *comm="")
{ Out<<comm<<T<<endl;
}

//=============================================
// Suppresses comments on successive lines
// (comments start a line with a #)
//=============================================
inline void SupprimeCommDiese(istream & In)
{ 
  char c;
  booleen Comm=VRAI;
  while(Comm){
    c=In.peek();
    while(isspace(c)){ 
      In.get(c); c=In.peek(); }
    if(c=='#'){
      while( In.get(c) && (c!='\n') && (c!=EOF));
    }
    else {
      Comm=FAUX;
    }
  }
  return;
}


//=============================================
// Supresses potential comments from the 
//  current position, get the new element
//  (at the begining of a line), and discards
//  the remaining of that line
//=============================================
template<class type>
inline void Mget(istream & In,type & element,char *comm="")
{ 
  char c;
  if(comm[0]!='\0')
    cout<<comm;
  SupprimeCommDiese(In);
  In>>element; while( In.get(c) && (c!='\n'));
}

//=============================================
// Same as above, but for strings
//=============================================
inline void Mget(istream & In,char  * str,char *comm="",int lmax=64)
{ char c;
 if(comm[0]!='\0')
   cout<<comm;
 SupprimeCommDiese(In);
 int i=0;
 while( i<(lmax-1) && In.get(str[i]) && !isspace(str[i]))
   i++;
 if( i>=(lmax-1)){
   str[i]='\0';
   while(In.get(c) && (c!='\n'));
 }
 else {
   c=str[i];
   str[i]='\0';
   if((c!='\n'))
     while(In.get(c) && (c!='\n'));
 }
 cout<<" ("<<str<<")"<<endl;
 return;
}

//=============================================
// Older C versions
//=============================================

inline  void  SupprimeBlancsFile(FILE *f) 
{ char c; 

 c=getc(f);
 while( c=='\n' || c==' ' || c=='\t' || c=='\r')
   c=getc(f); 
 ungetc(c,f);
 return;
} 

inline  void  SupprimeCommDieseFile(FILE *f) 
{ char c; 
 booleen Comm=VRAI; 
 while(Comm){ 
   SupprimeBlancsFile(f);
   c=getc(f);
   if(c!= EOF && c=='#'){ 
     while(c!= EOF && c!='\n')
       c=getc(f); 
   } 
   else {
     Comm=FAUX; 
     ungetc(c,f);
   }
 } 
 return;
} 

#define get_int(pentier,dummy) scanf("%d",(pentier)); \
			  while( (dummy=getchar()) != EOF && (dummy!='\n'))

#define get_float(pfloat,dummy) scanf("%f",(pfloat)); \
			  while( (dummy=getchar()) != EOF && (dummy!='\n'))

#define get_double(pdouble,dummy) scanf("%lf",(pdouble)); \
			  while( (dummy=getchar()) != EOF && (dummy!='\n'))

#define get_string(pchar,dummy) scanf("%s",(pchar)); \
			  while( (dummy=getchar()) != EOF && (dummy!='\n'))

#define fget_string(f,pchar,dummy) fscanf(f,"%s",(pchar)); \
			  while( (dummy=fgetc(f)) != EOF && (dummy!='\n'))




#endif	// IOASCII_HH
