#include "EasyExampleClasses.h"

int main (int argc, char **argv)
{

  int iter,NbIter=100,NbParticles=100;

  MyData       md;
  real         sigma2Dyn=0.5,sigma2Like=0.5;
  MyTracker    mt(&md,NbParticles,sigma2Dyn,sigma2Like);

  mt.init();

  // filtering loop
  iter=0;
  while(iter<NbIter){

    // perform iteration with current data
    mt.iterate();

    // DISPLAY SOME RESULT
    bf_MixedParticleDistribution *pCurrent=(bf_MixedParticleDistribution *)mt.m_pParticleFilter->m_pParticleSet;
  
    real  mean[2],variance[2];

    // Getting mean and variance
    pCurrent->getMeanVariance(mean,variance,0);

    // output observation, mean and variance
    printf("%f \t%f \t%f \n",md.observation,mean[0],variance[0]);

    // switch to next data
    mt.nextData();

    iter++;
  }


}
