#ifndef BICV_IPLIMAGESDATARV_C_AND_H_INC
#define BICV_IPLIMAGESDATARV_C_AND_H_INC

#include "bf_DataRandomVariable.h"
#include "ipcv_BaseSeqImage.h"

using namespace ImageProcessing;

namespace Torch {

//-----

/** Data random variable that provides Ipl images.
    - bands for histogram tracker in first pointer
    - rgb image (or YUV) in second pointer


    Class is kept as a template,
    as bands could be of anothe type than uchar
    (for instance, if bands represents response to 
      different filters).

    TypeOfPreprocessing (for first pointer): 
          from read color image, how are images tranformed

    For new preprocessing, the basic changes should be made
    in :
    - initData()  --> change memory allocation
    - computeIplBands() --> to perform preprocessing, that is,
                            compute the response in the different
                            bands from the color image
			    
    
    @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
    @author Daniel Gatica-Perez (gatica@idiap.ch)
*/

  template <class Type>
    class bicv_IplImagesDataRV_CandH :
    public virtual bf_DataRandomVariable
    {
    public:
      ipcv_MultiImage<Type>                 m_cImages;
      ipcv_BaseSeqImage<ip_ColorElement8u> *m_pImageSequence;

    private:
      bool                                  m_bDataAvailable;
      int                                   m_iTypeofPreprocessing;
      ipcv_Image<ip_ColorElement8u>         m_cTempImage;

    public:
      ///
      bicv_IplImagesDataRV_CandH(ipcv_BaseSeqImage<ip_ColorElement8u>    * Seq,
			   int TypeOfPreprocessing=0) :
	m_cImages (),m_iTypeofPreprocessing(TypeOfPreprocessing)
	{
	  m_pImageSequence = Seq;
	  m_bDataAvailable =false;
	}
      
      //-----
      virtual void initData(){
	m_bDataAvailable=m_pImageSequence->firstImage();

	
	// printf("Preprocessing %d m_bDataAvailable = %d \n",m_iTypeofPreprocessing,m_bDataAvailable); fflush(stdout);

	// FIRST POINTER
	if(dataAvailable()){
	  switch(m_iTypeofPreprocessing){
	  case 0:  // rgb   images
	  default:
	    m_cImages.allocateMem(3,m_pImageSequence->currentCvImage()->nbLines(),
				  m_pImageSequence->currentCvImage()->nbColumns());
	    break;

	  case 1:  // HSV   images
	    printf("nblines %d nbcol = %d \n",m_pImageSequence->currentCvImage()->nbLines(),
		   m_pImageSequence->currentCvImage()->nbColumns()); fflush(stdout);

	    m_cImages.allocateMem(3,m_pImageSequence->currentCvImage()->nbLines(),
				  m_pImageSequence->currentCvImage()->nbColumns()); 
	    m_cTempImage.allocateMem(m_pImageSequence->currentCvImage()->nbLines(),
				     m_pImageSequence->currentCvImage()->nbColumns());
	    break;
	  }
	}

	//	printf("m_cData.n_nodes %d \n",m_cData.n_nodes); fflush(stdout);

	if(m_cData.n_nodes==0)
	  addToData((real *)m_cImages.iplImages());
	else
	  m_cData.nodes[0]=(real *)m_cImages.iplImages();
	computeIplBands(*m_pImageSequence->currentCvImage());

	//	printf("m_cData.n_nodes %d \n",m_cData.n_nodes); fflush(stdout);

	// SECOND POINTER
	if(m_cData.n_nodes==1)
	  addToData((real *)m_pImageSequence->currentCvImage());
	else
	  m_cData.nodes[1]=(real *)m_pImageSequence->currentCvImage();
      }
      
      //-----
      virtual void nextData(){
	m_bDataAvailable=m_pImageSequence->nextImage();
	if(dataAvailable()) {
	  // FIRST POINTER
	  computeIplBands(*m_pImageSequence->currentCvImage());
	  // SECOND POINTER
	  if(m_cData.n_nodes==1)
	    addToData((real *)m_pImageSequence->currentCvImage());
	  else
	    m_cData.nodes[1]=(real *)m_pImageSequence->currentCvImage();
	}
      }
      
      //-----
      virtual bool dataAvailable(){
	return m_bDataAvailable;
      }
      
      //--------------------------------------------
      virtual void computeIplBands(ipcv_Image<ip_ColorElement8u> & ImaIn){
	switch(m_iTypeofPreprocessing){
	case 0:  // rgb   images
	default:
	  m_cImages.convert(ImaIn);
	  break;

	case 1:  // HSV   images
	  cvCvtColor(ImaIn.m_pImage,m_cTempImage.m_pImage, CV_RGB2HSV);
	  m_cImages.convert(m_cTempImage);
	  break;
	}	  
      }
			    
      
      //--------------------------------------------
	
      //-----
      virtual ~bicv_IplImagesDataRV_CandH(){}
    };

}

#endif
