#ifndef BICV_CONTOUR_TRACKER_INC
#define BICV_CONTOUR_TRACKER_INC

#include "general.h"

// open cv
#include "cv.h"

#include "bicv_ContourLikelihood.h"
#include "bicv_TransformedEllipseTemplate.h"
#include "bf_MixedParticleDistribution.h"
#include "bf_Trainer.h"
#include "bf_DynamicAR.h"
#include "bf_ParticleFilter.h"

using namespace ImageProcessing;

namespace Torch {
  //-----

  /** 

     Particle filter that uses 
     - A contour as the object model to compute the observation likelihood
     - a planar Transform 
     - an AR dynamic
      
    
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  //===================================================
  //
  //
  //===================================================

  class   bicv_ContourTracker : virtual public bf_Trainer  {

    //-- members

  public:
    // for the particles
    bf_RandomGenerator                *m_pRng1;
    bf_RandomGenerator                *m_pRng2;
    bf_MixedParticleDistribution      *m_pPosteriorDistribution;  
    bf_MixedParticleDistribution      *m_pAuxDistribution;

    // for the dynamical model
    bf_DynamicAR                      *m_pDynamics;

    // for the contour likelihood
    ip_PlanarTransform                *m_pTrans;
    ipcv_ContourTemplate              *m_pTemplate;
    bicv_TransformedEllipseTemplate   *m_pMeasurer;
    bf_EvalDistReal                   *m_pProbaLikelihood;
    bicv_ContourLikelihood            *m_pLikelihood;

    // filter and data are inherited from the Trainer
    // nevertheless, here we declare a particle filter
    bf_ParticleFilter                 *m_pParticleFilter;

    //-- member functions
    
  public:

    //-----

    bicv_ContourTracker(int NberOfParticles,
			ip_PlanarTransform *pT,
			int numPtsContour, int measureType,
			real lineLength, int numPtsSearchLine,
			ip_Ellipse *pInitEllipse,			
			bf_DataRandomVariable *pZ,
			real K, real sigma);

    //----- 
    virtual void init(long N=-1);   
    
    //----- 
    virtual ~bicv_ContourTracker();

  };

   
}

#endif   // BICV_CONTOUR_TRACKER_INC
