#ifndef BICV_CONTOUR_LIKELIHOOD_INC
#define BICV_CONTOUR_LIKELIHOOD_INC

#include "general.h"
#include "bf_RandomVariable.h"
#include "bf_RandomGenerator.h"
#include "bf_DistributionReal.h"
#include "bf_RVFunctions.h"

// open cv: not needed in this implementation
#include "cv.h"

#include "ip_Image.h"
#include "ipcv_ContourTemplate.h"
#include "bi_ContourMeasurer.h"


using namespace ImageProcessing;

namespace Torch {
  //-----

  /**       
    
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */

  /********************************************************
  class         bicv_ContourLikelihood
  models   p(Z_t|X_t) = prod p(z|x) 
  where Z = {z} is a set of 1-D observations extracted from
  a set of normal lines to a contour.

  Each p(z|x), where x describes a point on the hypothesized
  contour (as extracted from X ), is modeled as described in 
  Blake/Isard's book:

  p(z|x) \propto 1 + K sum_m exp[ - (z_m - x)^2 / 2 \sigma^2]

  where K is a constant that depends on several parameters
  *********************************************************/

  class   bicv_ContourLikelihood : public bf_EvalCondDist {
  public:
    ipcv_ContourTemplate    *m_pCtemplate;
    bi_ContourMeasurer      *m_pCmeasurer;
    bf_EvalDistReal         *m_pProb;         //to evaluate each p(z|x)

    // For extracting transform params from state
    bf_RvToRvFunction       *m_pExtractParams;
    
    // For extracting ip_Image* used for contour measurements 
    bf_RvToRvFunction       *m_pExtractIplImages;
 
    // for temporary storage or access
    ip_Image<ip_ColorElement8u> *m_pBands;
    
    //-----
    bicv_ContourLikelihood(ipcv_ContourTemplate *pCtemplate,
			   bi_ContourMeasurer *pCmeasurer,
			   bf_EvalDistReal     *pProb,
			   bf_RvToRvFunction   *pExtractParams=NULL,
			   bf_RvToRvFunction   *pExtractIplImages=NULL);

    //----
    virtual void  create(ipcv_ContourTemplate *pCtemplate,
			 bi_ContourMeasurer   *pCmeasurer,
			 bf_EvalDistReal      *pProb,
			 bf_RvToRvFunction    *pExtractParams=NULL,
			 bf_RvToRvFunction    *pExtractIplImages=NULL);

    //----
    virtual void  freeMemory();
    
    //----
    virtual bf_RandomVariable *extractTransformParams(bf_RandomVariable *pX);

    //----
    virtual void extractBands(bf_RandomVariable *pZ);

    //----
    virtual real evaluateConditionalRV(bf_RandomVariable *pZ,bf_RandomVariable *pX);

    //----
    virtual real priorOnStates(real *pPars, int dim);

    //----
    virtual ~bicv_ContourLikelihood()
    {freeMemory();}


  };

   
}

#endif  // BICV_CONTOUR_LIKELIHOOD_INC
