#ifndef BICV_CONTOUR_HISTOGRAM_TRACKER_INC
#define BICV_CONTOUR_HISTOGRAM_TRACKER_INC

#include "general.h"

// open cv
#include "cv.h"

#include "bicv_HistogramLikelihood.h"
#include "bicv_ChessBoardTemplate.h"

#include "bicv_ContourLikelihood.h"
#include "bicv_TransformedEllipseTemplate.h"

#include "bf_MixedParticleDistribution.h"
#include "bf_Trainer.h"
#include "bf_DynamicAR.h"
#include "bf_ParticleFilter.h"

using namespace ImageProcessing;

namespace Torch {
  //-----

  /** 

     Particle filter that uses 
     - The "chess-board" object model as Histogram Likelihood
     - An ellipse object model as shape Likelihood
     - a planar Transform 
     - an AR dynamic
      
    
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  //===================================================
  //
  //
  //===================================================

#define    LIKELIHOOD_HISTO              1
#define    LIKELIHOOD_CONTOUR            2
#define    LIKELIHOOD_BACKGROUND         4

#define    LIKELIHOOD_HISTO_ONLY         LIKELIHOOD_HISTO
#define    LIKELIHOOD_CONTOUR_ONLY       LIKELIHOOD_CONTOUR
#define    LIKELIHOOD_CONTOUR_AND_HISTO  LIKELIHOOD_HISTO | LIKELIHOOD_CONTOUR

  class   bicv_ContourAndHistogramTracker : virtual public bf_Trainer  {

    //-- members

  public:
    // for the particles
    bf_RandomGenerator                *m_pRng1;
    bf_RandomGenerator                *m_pRng2;
    bf_MixedParticleDistribution      *m_pPosteriorDistribution;  
    bf_MixedParticleDistribution      *m_pAuxDistribution;

    // for the dynamical model
    bf_DynamicAR                      *m_pDynamics;

    // for the likelihoods
    ip_PlanarTransform                *m_pTrans;
    bf_EvalCondDist                  **m_pLikelihoodTable;
    int                                m_iNumberOfLikelihood;
    bf_EvalCondDist                   *m_pLikelihood;

    // for the histogram likelihood
    int                                m_iLikeHisto;
    ipcv_HistogramTemplate            *m_pHistoTemplate;
    int                                m_iNumberOfBands;
    ip_BoundingBox                     m_cInitBB;
    bicv_ChessBoardTemplate           *m_pHistoMeasurer;
    bf_EvalDistReal                   *m_pHistoProbaLikelihood;
    bf_EvalCondDist                   *m_pHistoLikelihood;

    // for the shape likelihood
    int                                m_iLikeContour;
    ipcv_ContourTemplate              *m_pContourTemplate;
    bicv_TransformedEllipseTemplate   *m_pContourMeasurer;
    bf_EvalDistReal                   *m_pContourProbaLikelihood;
    bicv_ContourLikelihood            *m_pContourLikelihood;



    // filter and data are inherited from the Trainer
    // nevertheless, here we declare a particle filter
    bf_ParticleFilter                 *m_pParticleFilter;

    //-- member functions
    
  public:

    //================================================================

    //-- constructors

    bicv_ContourAndHistogramTracker(int NberOfParticles, ip_PlanarTransform *T,
				    //
				    int LikelihoodModel,
				    // parameters of the dynamic
				    real DynamicsTranslationStdev,
				    real DynamicsAffineStdev,
				    // HISTOGRAM PARAMETERS
				    int SplitHeight,int SplitWidth,
				    int  DIM_C,
				    real Lambda,real Z, // parameters of the likelihood
				    // for the histogram
				    int  number_of_bands, // numbers of band to take 
				    // into account for histogram computation 
				    // SHAPE PARAMETERS
				    int numPtsContour, int measureType,
				    real lineLength, int numPtsSearchLine,
				    real K, real sigma,
				    // INITIAL POSITION
				    ip_BoundingBox   initBB,
				    // DATA
				    bf_DataRandomVariable *pZ
				    );

    //================================================================

    // Initialisation
    virtual void init(long N=-1);


    //================================================================
    
    virtual ~bicv_ContourAndHistogramTracker();

  };

   
}

#endif
