#include "bicv_ChessBoardTemplate.h"

using namespace ImageProcessing;

namespace Torch {

  //================================================================
  
  //-- constructors
  
  //-----
  bicv_ChessBoardTemplate::bicv_ChessBoardTemplate() :
    bicv_BoundingBoxesSetTemplate(), m_iNbSplitCo(0), m_iNbSplitLi(0)
  {
  }
  
  //-----
  bicv_ChessBoardTemplate::bicv_ChessBoardTemplate(int SplitCo, int SplitLi,
						   ip_PlanarTransform *Transf) :
      bicv_BoundingBoxesSetTemplate() 
  {
    create(SplitLi,SplitCo,Transf);
  }
  
  
  
  //-----
  bicv_ChessBoardTemplate::bicv_ChessBoardTemplate(int SplitCo, int SplitLi,
						   ip_PlanarTransform *Transf,
						   ip_BoundingBox  * BBox,
						   bool with_center) :
    bicv_BoundingBoxesSetTemplate() 
  {
    create(SplitLi,SplitCo,Transf,BBox,with_center);
  }
  
  //================================================================
  
  //-- memory management
  

  //----
  void  bicv_ChessBoardTemplate::create(int SplitCo, int SplitLi,
					ip_PlanarTransform *Transf,
					ip_BoundingBox   * BBox,
					bool with_center){
    bicv_BoundingBoxesSetTemplate::create(NULL,Transf,SplitLi*SplitCo,true,false);
    m_iNbSplitLi=SplitLi;
    m_iNbSplitCo=SplitCo;
    
    if(BBox!=NULL)
      setSurroundingBB(*BBox,with_center);

  }
  
  

  //----
  void  bicv_ChessBoardTemplate::freeMemory(){
    bicv_BoundingBoxesSetTemplate::freeMemory();
    m_iNbSplitLi=0;
    m_iNbSplitCo=0;
  }
  
  //================================================================
  
  void bicv_ChessBoardTemplate::setSurroundingBB(ip_BoundingBox SBB,bool with_center){
    
    int i,j,stepli,stepco;
    
    stepli=SBB.height()/m_iNbSplitLi;
    stepco=SBB.width()/m_iNbSplitCo;

    m_cSurroundingBox=SBB;
    
    //  printf("%d %d   %d \n",m_iNbSplitCo,m_iNbSplitLi,nbBoxes());
    // printf("%d %d  \n",stepco,stepli);

    for(i=0;i<m_iNbSplitCo-1;i++){
      for(j=0;j<m_iNbSplitLi-1;j++){
	m_pBBTemplate[j*m_iNbSplitCo+i].init(SBB.firstColumn()+i*stepco,
					     SBB.firstLine()+j*stepli,  
					     SBB.firstColumn()+(i+1)*stepco,
					     SBB.firstLine()+(j+1)*stepli);  
	
      }
      // to be sure that we fill the input Bounding Box
      // Note that Bounding Box on the right side and bottom  might
      // be bigger than the other ones
      m_pBBTemplate[j*m_iNbSplitCo+i].init(SBB.firstColumn()+i*stepco,
					   SBB.firstLine()+j*stepli,
					   SBB.firstColumn()+(i+1)*stepco,
					   SBB.lastLine());
    }
    for(j=0;j<m_iNbSplitLi-1;j++){
      //      printf("i=%d j=%d index=%d \n",i,j,j*m_iNbSplitCo+i);
      m_pBBTemplate[j*m_iNbSplitCo+i].init(SBB.firstColumn()+i*stepco,
					   SBB.firstLine()+j*stepli,  
					   SBB.lastColumn(),
					   SBB.firstLine()+(j+1)*stepli);  
      
    }
    //    printf("i=%d j=%d index=%d \n",i,j,j*m_iNbSplitCo+i);
    m_pBBTemplate[j*m_iNbSplitCo+i].init(SBB.firstColumn()+i*stepco,
					 SBB.firstLine()+j*stepli,
					 SBB.lastColumn(),
					 SBB.lastLine());
    
    if(with_center){     
      ip_Pixel  centroid;
      center();
      centroid=getCenter();
      m_cSurroundingBox.translate(-centroid.m_iCo,-centroid.m_iLi);
    }
  }
  
  
  //================================================================
  
  void bicv_ChessBoardTemplate::draw(ip_Image<ip_ColorElement8u> &Ima,
				ip_ColorElement8u color,bool current,bool surrounding,int thickness){
 
    if(surrounding){
      if(current){
		  ip_BoundingBox  SBB_Transform=transformBB(m_cSurroundingBox);
		  SBB_Transform.draw(Ima,color ,thickness);
      }
      else
		  m_cSurroundingBox.draw(Ima,color,thickness);
    }
    else
      bicv_BoundingBoxesSetTemplate::draw(Ima,color,current);

  }

  //================================================================
  
  void bicv_ChessBoardTemplate::draw(ip_Image<uchar> &Ima,
				unsigned char color,bool current,bool surrounding){
 
    if(surrounding){
      if(current){
	ip_BoundingBox  SBB_Transform=transformBB(m_cSurroundingBox);
	SBB_Transform.draw(Ima,color,2);
      }
      else
	m_cSurroundingBox.draw(Ima,color,2);
    }
    else
      bicv_BoundingBoxesSetTemplate::draw(Ima,color,current);

  }



  //================================================================
  
  bicv_ChessBoardTemplate::~bicv_ChessBoardTemplate(){
    freeMemory();
  }
  
}

