#ifndef BF_UNI_GAUSSIAN_WITH_FACTOR_DISTRIBUTION_INC
#define BF_UNI_GAUSSIAN_WITH_FACTOR_DISTRIBUTION_INC

#include "bf_DistributionReal.h"

namespace Torch {
  //-----

  /** 
      Unidimensional Gaussian with an arbitrary factor distribution.

      p(x) = k * N(\mu, \sigma)

      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */


  //===================================================
  //
  // class   bf_UniGaussianWithFactorDistribution
  //
  //===================================================
  class bf_UniGaussianWithFactorDistribution : 
    virtual public bf_EvalDistReal {
    private:
    real         m_rK;
    real         m_rMean;
    real         m_rVar;
    real         m_rStd;
     
    public:
    bf_UniGaussianWithFactorDistribution(real K=1., real mean=0., real std=1.);

    virtual inline real evaluateReal(real *pX)
    {
      //return (1/(m_rK*2.51*m_rStd)) * exp(-1.*(*pX-m_rMean)*(*pX-m_rMean)/(2*m_rVar) );
      return exp(-(*pX-m_rMean)*(*pX-m_rMean)/(2*m_rVar) );
    }

    virtual ~bf_UniGaussianWithFactorDistribution(){}
  };

   
}

#endif  //BF_UNI_GAUSSIAN_WITH_FACTOR_DISTRIBUTION_INC
