#ifndef BF_EXPONENTIAL_DISTRIBUTION_INC
#define BF_EXPONENTIAL_DISTRIBUTION_INC

#include "bf_DistributionReal.h"

namespace Torch {
  //-----

  /** 
      Exponential distribution.

      Assumes that the input is only of size 1.

      p(x) = 1/Z exp(-lambda x)

      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */


  //===================================================
  //
  // class   bf_ExponentialDistribution
  //
  //===================================================
  class bf_ExponentialDistribution : 
    virtual public bf_EvalDistReal {
    private:
    real         m_rLambda;
    real         m_rOneOverZ;
    
    public:
    bf_ExponentialDistribution(real Lambda,real Z=-1.);

    virtual inline real evaluateReal(real *pX){
      return m_rOneOverZ*exp(-m_rLambda* *pX);
    }

    virtual ~bf_ExponentialDistribution(){}
  };

   
}

#endif
