#include "bf_DynamicAR.h"


namespace Torch {
  
  //===================================================
  //
  //  class  bf_DynamicAR
  //
  //  different linear AR model
  //  
  //
  //  Model Dynamic_AR2 :
  //    [ x_k; x_{k-1} ] = [ 2 , -1 ; 1 , 0][x_{k-1}; x_{k-2}] + [ 1; 0 ] white noise
  //
  //===================================================


  //-----
  bf_DynamicAR2::bf_DynamicAR2(int nbComponents,real *Var): m_cRng(0) {
    m_pRng=&m_cRng;
    create(nbComponents,Var);
  }

  //-----
  void bf_DynamicAR2::init(){}
  
  //-----
  void bf_DynamicAR2::create(int nbComponents,real *Var) {

    
    int i;
    m_iNbComponents = nbComponents;
    // set parameters :
    m_pStdDev=new real [m_iNbComponents];
    for(i=0;i<m_iNbComponents;i++){
      m_pStdDev[i]=sqrt(Var[i]);
    }
  }
  
  //-----
  int bf_DynamicAR2::nbComponents(){
    return m_iNbComponents;
  }
  
  //-----
  bf_DynamicARModel bf_DynamicAR2::dynamicModel(){
    return DynamicAR2;
  }
  
  //-----
  // WARNING : NUMBER of STATES  PER COMPONENT
  // if no number given, return total number of states
  int bf_DynamicAR2::nbStates(int component){
    if(component<0 || component>=m_iNbComponents)
      return 2*m_iNbComponents;
    else
      return  2;
  }
  
  //----
  // There is only one noise value per component
  void  bf_DynamicAR2::setNoiseVariance(int component,real variance){
    m_pStdDev[component]=sqrt(variance);
  }


  //-----
  void  bf_DynamicAR2::initState(real *state,real *componentvalues){
    int i;
    for(i=0;i<m_iNbComponents;i++){
      state[2*i]=componentvalues[i];
      state[2*i+1]=componentvalues[i];
    }
  }
  
  //-----
  bf_DynamicAR2::~bf_DynamicAR2(){
    if(m_iNbComponents>0){
      delete []    m_pStdDev;
    }
  }






  //-----
  bf_DynamicAR2bis::bf_DynamicAR2bis(int nbComponents,real *Var): m_cRng(0) {
    m_pRng=&m_cRng;
    create(nbComponents,Var);
  }

  //-----
  void bf_DynamicAR2bis::init(){}
  
  //-----
  void bf_DynamicAR2bis::create(int nbComponents,real *Var) {

    
    int i;
    m_iNbComponents = nbComponents;
    // set parameters :
    m_pStdDev=new real [m_iNbComponents];
    for(i=0;i<m_iNbComponents;i++){
      m_pStdDev[i]=sqrt(Var[i]);
    }
  }
  
  //-----
  int bf_DynamicAR2bis::nbComponents(){
    return m_iNbComponents;
  }
  
  //-----
  bf_DynamicARModel bf_DynamicAR2bis::dynamicModel(){
    return DynamicAR2bis;
  }
  
  //-----
  // WARNING : NUMBER of STATES  PER COMPONENT
  // if no number given, return total number of states
  int bf_DynamicAR2bis::nbStates(int component){
    if(component<0 || component>=m_iNbComponents)
      return 3*m_iNbComponents;
    else
      return  3;
  }
  
  //----
  // There is only one noise value per component
  void  bf_DynamicAR2bis::setNoiseVariance(int component,real variance){
    m_pStdDev[component]=sqrt(variance);
  }


  //-----
  void  bf_DynamicAR2bis::initState(real *state,real *componentvalues){
    int i;
    for(i=0;i<m_iNbComponents;i++){
      state[3*i]=componentvalues[i];
      state[3*i+1]=componentvalues[i];
      state[3*i+2]=componentvalues[i];
    }
  }
  
  //-----
  bf_DynamicAR2bis::~bf_DynamicAR2bis(){
    if(m_iNbComponents>0){
      delete []    m_pStdDev;
    }
  }



















  //-----
  bf_DynamicAR3::bf_DynamicAR3(int nbComponents,real *Var,real *alpha): m_cRng(0) {
    m_pRng=&m_cRng;
    create(nbComponents,Var,alpha);
  }

  //-----
  void bf_DynamicAR3::init(){}
  
  //-----
  void bf_DynamicAR3::create(int nbComponents,real *Var,real *alpha) {

    
    int i;
    m_iNbComponents = nbComponents;
    // set parameters :
    m_pStdDev=new real [m_iNbComponents];
    m_pAlpha=new real [m_iNbComponents];
    for(i=0;i<m_iNbComponents;i++){
      m_pStdDev[i]=sqrt(Var[i]);
      if(alpha==NULL)
	m_pAlpha[i]=0.30;
      else
	m_pAlpha[i]=alpha[i];
    }
  }
  
  //-----
  int bf_DynamicAR3::nbComponents(){
    return m_iNbComponents;
  }
  
  //-----
  bf_DynamicARModel bf_DynamicAR3::dynamicModel(){
    return DynamicAR3;
  }
  
  //-----
  // WARNING : NUMBER of STATES  PER COMPONENT
  // if no number given, return total number of states
  int bf_DynamicAR3::nbStates(int component){
    if(component<0 || component>=m_iNbComponents)
      return 2*m_iNbComponents;
    else
      return  2;
  }
  
  //----
  // There is only one noise value per component
  void  bf_DynamicAR3::setNoiseVariance(int component,real variance){
    m_pStdDev[component]=sqrt(variance);
  }

  //----
  // 
  void  bf_DynamicAR3::setAlpha(int component,real alpha){
    m_pAlpha[component]=alpha;
  }

  //-----
  void  bf_DynamicAR3::initState(real *state,real *componentvalues){
    int i;
    for(i=0;i<m_iNbComponents;i++){
      state[2*i]=componentvalues[i];
      state[2*i+1]=0.; // speed = 0.
    }
  }
  
  //-----
  bf_DynamicAR3::~bf_DynamicAR3(){
    if(m_iNbComponents>0){
      delete []    m_pStdDev;
      delete []    m_pAlpha;
    }
  }









  //-----
  bf_DynamicAR3bis::bf_DynamicAR3bis(int nbComponents,real *Var,real *alpha): m_cRng(0) {
    m_pRng=&m_cRng;
    create(nbComponents,Var,alpha);
  }

  //-----
  void bf_DynamicAR3bis::init(){}
  
  //-----
  void bf_DynamicAR3bis::create(int nbComponents,real *Var,real *alpha) {

    
    int i;
    m_iNbComponents = nbComponents;
    // set parameters :
    m_pStdDev=new real [m_iNbComponents];
    m_pAlpha=new real [m_iNbComponents];
    for(i=0;i<m_iNbComponents;i++){
      m_pStdDev[i]=sqrt(Var[i]);
      if(alpha==NULL)
	m_pAlpha[i]=0.30;
      else
	m_pAlpha[i]=alpha[i];
    }
  }
  
  //-----
  int bf_DynamicAR3bis::nbComponents(){
    return m_iNbComponents;
  }
  
  //-----
  bf_DynamicARModel bf_DynamicAR3bis::dynamicModel(){
    return DynamicAR3bis;
  }
  
  //-----
  // WARNING : NUMBER of STATES  PER COMPONENT
  // if no number given, return total number of states
  int bf_DynamicAR3bis::nbStates(int component){
    if(component<0 || component>=m_iNbComponents)
      return 3*m_iNbComponents;
    else
      return  3;
  }
  
  //----
  // There is only one noise value per component
  void  bf_DynamicAR3bis::setNoiseVariance(int component,real variance){
    m_pStdDev[component]=sqrt(variance);
  }

  //----
  // 
  void  bf_DynamicAR3bis::setAlpha(int component,real alpha){
    m_pAlpha[component]=alpha;
  }

  //-----
  void  bf_DynamicAR3bis::initState(real *state,real *componentvalues){
    int i;
    for(i=0;i<m_iNbComponents;i++){
      state[3*i]=componentvalues[i];
      state[3*i+1]=0.; // speed = 0.
      state[3*i+2]=0.; // acceleration = 0.
    }
  }
  
  //-----
  bf_DynamicAR3bis::~bf_DynamicAR3bis(){
    if(m_iNbComponents>0){
      delete []    m_pStdDev;
      delete []    m_pAlpha;
    }
  }
  
}


