#include "bf_DistributionReal.h"

namespace Torch {


  //===================================================
  //
  //
  //===================================================
  //-----
  real bf_EvalDistReal::evaluateRV(bf_RandomVariable *pX){
    return evaluateReal((real *)pX->m_cData.nodes[0]);
  }


  //===================================================
  //
  //
  //===================================================
  //-----
  void bf_SampleDistReal::sampleRV(bf_RandomVariable *pX){
    sampleReal((real *)pX->m_cData.nodes[0]);
  }
  
  //-----
  void bf_SampleDistReal::sampleReal_N(real **pX,int N){
    int i;
    for(i=0;i<N;i++)
      sampleReal(pX[i]);
  } 


  //===================================================
  //
  //
  //===================================================
  //-----
  bf_ConditionalReal::bf_ConditionalReal() :
  bf_Conditional() 
  {
    m_pConditionalReal=new bf_RandomVariable;
    //m_pConditionalReal->m_pData=new List;
    // to use the list utilities
    // and add one element in the list
    m_pConditionalReal->addToData((real *)NULL);
	 
  }

  //-----
  // setting m_pConditional to Y
  inline void bf_ConditionalReal::setConditionalRV(bf_RandomVariable *pY){
    bf_Conditional::setConditionalRV(pY); // for safety, not necessary normally
    m_pConditionalReal->m_cData=pY->m_cData;
  }
  
  // getting Conditional 
  inline bf_RandomVariable *bf_ConditionalReal::getConditionalRV(){
    return m_pConditionalReal;
  }
    
  //-----
  // setting m_pConditionalReal to Y
  inline void bf_ConditionalReal::setConditionalReal(real *pY){
    m_pConditionalReal->m_cData.nodes[0]=pY;
  }
  
  //-----
  // getting m_pConditionalReal
  inline real  * bf_ConditionalReal::getConditionalReal(){
    return (real *)m_pConditionalReal->m_cData.nodes[0];
  }

  //-----
  // 
  bf_ConditionalReal::~bf_ConditionalReal(){
    delete m_pConditionalReal;
  }


  //===================================================
  //
  //
  //===================================================
  //-----
  real bf_EvalCondDistReal::evaluateConditionalRV(bf_RandomVariable *pX,
					 bf_RandomVariable *pY)
  {
    if (pX->m_cData.n_nodes>0){
      if(pY->m_cData.n_nodes>0)
	return evaluateConditionalReal(pX->m_cData.nodes[0],
				       (real *)pY->m_cData.nodes[0]);
      else
	return evaluateConditionalReal(pX->m_cData.nodes[0],(real *)NULL);
    }
    else {
      if(pY->m_cData.n_nodes>0)
	return evaluateConditionalReal((real *)NULL,(real *)pY->m_cData.nodes[0]);
      else
	return evaluateConditionalReal((real *)NULL,(real *)NULL);
    }
  }

  //-----
  // computing P ( X | stored conditional  )
  real bf_EvalCondDistReal::evaluateRV(bf_RandomVariable *pX){
    if(pX->m_cData.n_nodes>0){
      return evaluateConditionalReal((real *)pX->m_cData.nodes[0],
				     getConditionalReal());
    }
    else
      return evaluateConditionalReal((real *)NULL,getConditionalReal()); 
    
  }

   //-----
  // computing P ( X | stored conditional  )
  real bf_EvalCondDistReal::evaluateReal(real *pX){
    return evaluateConditionalReal(pX,getConditionalReal());
  }
  
  //===================================================
  //
  //
  //===================================================
  //-----
  void bf_SampleCondDistReal::sampleConditionalRV(bf_RandomVariable *pX,
						  bf_RandomVariable *pY)
  {
    if (pX->m_cData.n_nodes>0){
      if(pY->m_cData.n_nodes>0)
	return sampleConditionalReal(pX->m_cData.nodes[0],
				       (real *)pY->m_cData.nodes[0]);
      else
	return sampleConditionalReal(pX->m_cData.nodes[0],(real *)NULL);
    }
    else {
      printf("pX real variable has no place to hold the data\n");
      exit(0);
    }
  }

  //-----
  // sampling P ( X | stored conditional  )
  void  bf_SampleCondDistReal::sampleRV(bf_RandomVariable *pX){
    if (pX->m_cData.n_nodes>0){
      sampleConditionalReal(pX->m_cData.nodes[0],getConditionalReal());  
    }
    else {
      printf("pX real variable has no place to hold the data\n");
      exit(0);
    }
  }

  //-----
  // sampling P ( X | stored conditional  )
  void  bf_SampleCondDistReal::sampleReal(real *pX){
    sampleConditionalReal(pX,getConditionalReal());
  }
  
  //===================================================
  //
  //
  //===================================================
  //-----
  void bf_EvalSampleCondDistReal::sampleRV(bf_RandomVariable *pX){
    if (pX->m_cData.n_nodes>0){
      bf_SampleCondDistReal::sampleReal((real *)pX->m_cData.nodes[0]);
    }
    else {
      printf("pX real variable has no place to hold the data\n");
      exit(0);
    }
  }


  real bf_EvalSampleCondDistReal::evaluateRV(bf_RandomVariable *pX){
    if (pX->m_cData.n_nodes>0){
      return bf_EvalCondDistReal::evaluateReal((real *)pX->m_cData.nodes[0]);
    }
    else {
      printf("pX real variable has no place to hold the data\n");
      exit(0);
    }
  }

}
