#ifndef BF_DISTRIBUTION_INC
#define BF_DISTRIBUTION_INC

#include "general.h"
#include "bf_RandomVariable.h"
#include "bf_RandomGenerator.h"

namespace Torch {
  //-----

  /** 
      Provides a basic description of distribution that 
      work on random variables (all members functions ends with RV)

      Name : bf_FuncType
      
      P(X)  (Type = Dist)   or P(X|Y) (Type = CondDist)

      Distribution are named according to what they
      provide :
      Func=Eval   -----> distribution that can be evaluated
      Func=Sample -----> distribution that can be sampled
      Func=EvalSample -> distribution that can be evaluated and sampled
      
    
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  //===================================================
  //
  //    class         bf_EvalDist 
  //
  //===================================================
  class bf_EvalDist {
  public:

    //dgp: there was no constructor!
    bf_EvalDist() {}

    virtual real evaluateRV(bf_RandomVariable *pX)=0;
    
    virtual ~bf_EvalDist(){}
  };


  //===================================================
  //
  //    class         bf_SampleDist
  //
  //===================================================
  class bf_SampleDist  {
  public:
    // Generator that should be used by the sampling function
    // should be inherited from distribution
    bf_RandomGenerator   *m_pRng; 
    
  public:
    bf_SampleDist(bf_RandomGenerator *_rng) :
      m_pRng(_rng) 
      {      };

    // Not a good thing, but just to avoid all
    // direct and undirect derived class to have to call 
    // the constructor with random generator
    bf_SampleDist() {    }
    
    
    virtual void sampleRV(bf_RandomVariable *pX)=0;
    
    virtual void sampleRV_N(bf_RandomVariable **pX,int N=1){
      int i;
      for(i=0;i<N;i++)
	sampleRV(pX[i]);
    }
    
    virtual ~bf_SampleDist(){}
  };


  //===================================================
  //
  //    class         bf_EvalSampleDist
  //
  //===================================================
  class bf_EvalSampleDist : 
    virtual public bf_EvalDist,
    virtual public bf_SampleDist 
    {
    public:
      ///-------
      // Not a good thing, but just to avoid all
      // direct and undirect derived class to have to call 
      // the constructor with random generator
      bf_EvalSampleDist() {      }
      
      bf_EvalSampleDist(bf_RandomGenerator *_rng) :
	bf_SampleDist(_rng) 
	{	  m_pRng=_rng; // for user's safety...
	};
      
      ///-------
      
      virtual ~bf_EvalSampleDist(){}
    };


  //===================================================
  //
  //   class     bf_Conditional
  //
  //===================================================
  class bf_Conditional {

  private:
    bf_RandomVariable   *m_pConditional;
    
  public:
    bf_Conditional();

    // setting m_pConditional to Y
    virtual inline void setConditionalRV(bf_RandomVariable *pY);
    
    // getting m_pConditional to Y
    virtual inline bf_RandomVariable *getConditionalRV();
    
  };


  //===================================================
  //
  //  class       bf_EvalCondDist
  //
  //===================================================
  class bf_EvalCondDist : 
    virtual public bf_EvalDist,
    virtual public bf_Conditional
    // public bf_Conditional
    {
    public:
      bf_EvalCondDist() 
	{}

      // computing P ( X | Y )
      virtual real evaluateConditionalRV(bf_RandomVariable *pX,
					 bf_RandomVariable *pY=NULL)=0;
      
      // computing P ( X | Y )
      virtual real evaluateRV(bf_RandomVariable *pX){
	return evaluateConditionalRV(pX,getConditionalRV());
      }
      
      virtual ~bf_EvalCondDist(){}
      
    };

  //===================================================
  //
  //  class        bf_SampleCondDist
  //
  //===================================================
  class bf_SampleCondDist : 
    virtual public bf_SampleDist,
    virtual public bf_Conditional
    {
    public:
      bf_SampleCondDist(bf_RandomGenerator *_rng) {
	m_pRng = _rng;
      };

     bf_SampleCondDist() {     };

     // computing P ( X | Y )
     virtual void sampleConditionalRV(bf_RandomVariable *pX,
				      bf_RandomVariable *pY=NULL)=0;

     // computing P ( X | Y )
     virtual void sampleConditionalRV_N(bf_RandomVariable **pX,
					bf_RandomVariable *pY,int N=1){
       int i;
       for(i=0;i<N;i++)
	 sampleConditionalRV(pX[i],pY);
     }
     
      
     virtual void sampleRV(bf_RandomVariable *pX){
       sampleConditionalRV(pX,getConditionalRV());
     }
     
     virtual ~bf_SampleCondDist(){}
     
    };
  
  //===================================================
  //
  //  class     bf_EvalSampleCondDist
  //
  //===================================================
  class bf_EvalSampleCondDist : 
    virtual public bf_SampleCondDist,
    virtual public bf_EvalCondDist,
    virtual public bf_EvalSampleDist
    {

    public:
      bf_EvalSampleCondDist() {}

      bf_EvalSampleCondDist(bf_RandomGenerator *_rng) {
	m_pRng=_rng;
      };
      
      //
      virtual inline void sampleRV(bf_RandomVariable *pX){
	bf_SampleCondDist::sampleRV(pX);
      }

      //
      virtual inline real evaluateRV(bf_RandomVariable *pX){
	return bf_EvalCondDist::evaluateRV(pX);
      }
      
      // 
      virtual ~bf_EvalSampleCondDist(){}

    };

   
}

#endif
