// ***************************************************************************
// tab.h
//
// version 27.11.95   Yann RICQUEBOURG, Laurent BONNAUD
//
//    Ajout JMO: methode in(li,co,ep)
//               methode in(pixel,ep)
//    Ajout JMO: methode in(li,co,ep) const
//               methode in(pixel,ep) const
// ****************************************************************************




/*
 Classe Tab<Type>
	= tableau 2D d'lments du <Type> prcis


 Membres publics:
  - dim1,dim2			: (int) representant les 2 dimensions (taille)
    dim1=nbli, dim2=nbco
  - min1,max1 et min2,max2	: (int) representant les bornes des indices (comprises)

  - constructeurs:
	Tab<int> T(10,20)	: partie dynamique bien reserve
	Tab<int> T		: partie dynamique non reserve
	Tab<int> T(10,20,tab)	: reservation + recopie tableau tab[] (du C normal)
	Tab<int> T(10,20,-2)	: reservation + initialisation partout a '-2'

	Tab<int> T(-5,5,-10,10) : reservation d'un tableau ou les indices
					sont dans [-5..5]x[-10..10]

  - accs & oprations:
	T(int i,int j) ou T(pixel p)  i : numero de ligne; j numero de colonne
	T1 = T2 = T3...		: recopie profonde
	T1 << T2 << T3...	: recopie partielle (permutation circulaire en fait)

  - fonctions:
	T.init(valeur)		: initialise tout le tableau avec 'valeur'
	T.dimensionne(dim1,dim2): (re-)dimensionne (allocation)
	T.init(dim1,dim2,val)	: (re-)dimensionne (allocation) et initialise
	T.initfromimage(dim1,dim2,imageptr)	
	                        : (re-)dimensionne (allocation) et initialise
	                        : ALLOCATION of IMAGE MEMORY NOT ASKED
	T1.permute(T2)		: permute T1 & T2 (rapide)

	T.sauve_pgm("fichier", ["commentaire"] )  : sauvegarde au format PGM
	T.sauve_raw("fichier")	: sauvegarde sans entete

	T.charge("fichier")	: englobe tous les formats detaills ci-dessous
	T.charge_pgm("fichier")	: charge, dim. & alloc dduites du fichier
	T.charge_raw("fichier", [int dim1, int dim2] )
				: charge (sans entete)
				   si dim. non-fournies et
				   lg(fichier) <> dimension courante => saisie clavier
*/



#ifndef TAB_HH
#define TAB_HH


#include <stdlib.h>				// pour exit();
#include <stdio.h>
#include <iostream.h>
#include <unistd.h>				// pour SEEK_END
#include "defs.h"				// pour les types octet et pixel
#include "try_fopen.h"


//#define DEBUG_TAB_HH				// Active quelques messages de trace
#define Msg_ES					// Messages lors des lectures/critures
#define	DIM_INDEFINIE	0			// Marque: partie dynamique inexistante


#ifdef DEBUG_TAB_HH
extern int count_Tab;
#endif

#define  AllAllocated   2
#define  PtrsAllocated  1
#define  NotAllocated   0

// Fonctions utilitaires locales...
// ***************************************************************************
template<class Type>
inline void Tab_permutation(Type & a, Type & b)
{Type	t = a;
	a = b;
	b = t;
}

#define ForAllPts(Im,li,co)  for((li)=(Im).inf1;(li)<=(Im).sup1;(li)++) \
                              for((co)=(Im).inf2;(co)<=(Im).sup2;(co)++)



// DECLARATION DE LA CLASSE Tab<Type>
// ***************************************************************************
template <class Type>
  class Tab
{
 public:
  int	 dim1, dim2;				// dimensions du tableau
  // PAR DEFAUT ; DIM1 NB DE LIGNES, ET DIM2 NB COLONNES
  int	 inf1,sup1, inf2,sup2;			// bornes des indices (COMPRISES)
  Type** ptr2;					// pointeur-2D sur les lments
#ifdef DEBUG_TAB_HH
  int	num_Tab;
#endif

  private :
    int  MemAllocated;  // Usefull for memory management
  // 2 : Memory entirely allocated
  // 1 : Image memory not-allocated, only pointers at the beginning of
  //     a line
  // 0 : no memory allocated at all;

 public:



// ---------------------------------------------------------------------------
Tab()						// constructeur sans arguments
 	{
# 	 ifdef DEBUG_TAB_HH
	   num_Tab = ++count_Tab;
  	   cout<<"Tab (no "<<num_Tab<<"): construit Tab(vide)"<<endl;
# 	 endif
	 dim1 = dim2 = DIM_INDEFINIE;		// marque: partie dynamique inexistante
	 inf1 = inf2 = DIM_INDEFINIE;		// marque: partie dynamique inexistante
	 sup1 = sup2 = DIM_INDEFINIE;		// marque: partie dynamique inexistante
	 MemAllocated=NotAllocated;	 
 	}

Tab(int inf_i,int sup_i, int inf_j,int sup_j);	// constructeur

Tab(int dim_i,int dim_j);			// constructeur

Tab(int dim_i, int dim_j, Type val_init);	// constructeur + initialise lments
  
Tab(int dim_i, int dim_j, Type* p);		// constructeur + recopie tableau p[]

Tab(const Tab& tab);				// constructeur par recopie


// ---------------------------------------------------------------------------
~Tab()
	{
#ifdef DEBUG_TAB_HH
	 if( dim1 != DIM_INDEFINIE )
		cout<<"Tab (no "<<num_Tab<<"): detruit Tab("<<inf1<<".."<<sup1<< "," <<inf2<<".."<<sup2<<")"<<endl;
	 else	cout<<"Tab (no "<<num_Tab<<"): detruit Tab(vide)"<<endl;
#endif
	 (*this).libere_partie_dyn();
    	}


public:
// ---------------------------------------------------------------------------
void alloue_partie_dyn(int inf_i, int sup_i, int inf_j, int sup_j)
  {
    
    MemAllocated=AllAllocated;
    
    
    dim1 = sup_i-inf_i+1;
    dim2 = sup_j-inf_j+1;
    
    if(dim1<=0 || dim2<=0)
      {cerr<<"Tab: dimensions non-valides ("<<dim1<<","<<dim2<<")"<<endl;
      exit(-1);
      }
    
    inf1 = inf_i;	sup1 = sup_i;
    inf2 = inf_j;	sup2 = sup_j;
    ptr2    	= (new Type* [dim1]) - inf1;
    ptr2[inf_i]	= (new Type  [dim1*dim2]) - inf2;
    
    if(ptr2==NULL || ptr2[inf_i]==NULL)
      {cerr<<"Tab: allocation memoire impossible..."<<endl;
      exit(-1);
      }
    
    for(int i=inf1+1; i<inf1+dim1; i++)
      ptr2[i] = ptr2[i-1] + dim2;
    
  }

void alloue_partie_dyn_from_image(Type *image,int inf_i, int sup_i, int inf_j, int sup_j)
  {
    
    MemAllocated=PtrsAllocated;
    
    dim1 = sup_i-inf_i+1;
    dim2 = sup_j-inf_j+1;
    
    if(dim1<=0 || dim2<=0)
      {cerr<<"Tab: dimensions non-valides ("<<dim1<<","<<dim2<<")"<<endl;
      exit(-1);
      }
    
    inf1 = inf_i;	sup1 = sup_i;
    inf2 = inf_j;	sup2 = sup_j;
    ptr2    	= (new Type* [dim1]) - inf1;
    ptr2[inf_i]	= image - inf2;
    
    if(ptr2==NULL || ptr2[inf_i]==NULL)
      {cerr<<"Tab: allocation memoire impossible..."<<endl;
      exit(-1);
      }
    
    for(int i=inf1+1; i<inf1+dim1; i++)
      ptr2[i] = ptr2[i-1] + dim2;
    
  }


void libere_partie_dyn()
  {

    if( dim1 != DIM_INDEFINIE )
      {
	switch(MemAllocated){
	case AllAllocated :
	  {delete [] (ptr2[inf1]+inf2);
	  delete [] (ptr2+inf1);
	  }
	  break;
	case   PtrsAllocated :
	  delete [] (ptr2+inf1);
	  break;
	default :
	  break;
	}
      }
  }
 
public:
// ---------------------------------------------------------------------------
  inline booleen  in(double li,double co)
    { if( floor(li)>=inf1 && floor(li)<sup1 && floor(co)>=inf2 && floor(co)<sup2)
      return VRAI;
    else return FAUX;
    }

  inline booleen  in(int li,int co,int ep=0)
    { if( li>=(inf1+ep) && li<=(sup1-ep) && co>=(inf2+ep) && co<=(sup2-ep))
      return VRAI;
    else return FAUX;
    }

  inline booleen in(pixel p,int ep=0)
    { return (*this).in(p.L,p.C,ep); }

  inline booleen  in(int li,int co,int ep=0) const
    { if( li>=(inf1+ep) && li<=(sup1-ep) && co>=(inf2+ep) && co<=(sup2-ep))
      return VRAI;
    else return FAUX;
    }

  inline booleen in(pixel p,int ep=0)  const
    { return (*this).in(p.L,p.C,ep); }

// ---------------------------------------------------------------------------
    void dimensionne(int dim_i, int dim_j);     // (re-)dimensionne tab
  void dimensionne(int inf_i, int sup_i,int inf_j, int sup_j);



// ---------------------------------------------------------------------------
void init(Type val_init);			// remplit tout tab avec une valeur

void init(int dim_i, int dim_j,			// (re-)dimensionne tab
          Type val_init				// et remplit tout tab avec une valeur
         );

// Here, the image memory can be provided by another information
// source
// if ManageImageDestroy==1, then the provided image will be destroyed
// when the Tab will be destroyed
// Otherwise, only table of ptrs to begining of each line will be destroyed
//
void initfromimage(int dim_i, int dim_j, Type* image,int ManageImageDestroy=0);

// ---------------------------------------------------------------------------
void permute(Tab<Type>& tab)			// tab1.permute(tab2)
						// => permutation RAPIDE (pointeurs)
{
 Tab_permutation( dim1,tab.dim1 );
 Tab_permutation( dim2,tab.dim2 );

 Tab_permutation( inf1,tab.inf1 );
 Tab_permutation( sup1,tab.sup1 );
 Tab_permutation( inf2,tab.inf2 );
 Tab_permutation( sup2,tab.sup2 );

 Tab_permutation( ptr2,tab.ptr2 );
 Tab_permutation( MemAllocated,tab.MemAllocated );
}


// ---------------------------------------------------------------------------
Tab<Type>& operator=(const Tab<Type>& tab);			// affectation (recopie profonde)
						// permet tab1 = tab2 = tab3;

Tab<Type>& operator<<(Tab<Type>& tab);		// transfert(recopie partielle)
						// permet tab1 << tab2 << tab3;

						// tab1 << tab2  : considrer que
						//   - tab1 pointe dsormais sur tab2
						//   - tab2 n'est plus !
						// (en fait, bas sur permute)


// ---------------------------------------------------------------------------
Type& operator()(int i, int j)			// tab(i,j) : modifiable
    	{return ptr2[i][j]; }

Type&  operator()(int i, int j) const 		// tab(i,j) pour les Tab const : fixe
    	{return ptr2[i][j]; }			// DEBUG : plus fixe...

Type& operator()(pixel p)			// tab(p) o p={paire de coordonnes}
    	{return ptr2[p.L][p.C]; }

Type&  operator()(pixel p) const 		// tab(p) pour les Tab const
    	{return ptr2[p.L][p.C]; } 		// DEBUG : plus fixe...


// ---------------------------------------------------------------------------
operator Type*() const				// cast Tab -> tableau-1D
	{ return ptr2[inf1]; }
operator Type*()				// cast Tab -> tableau-1D
	{ return ptr2[inf1]; }

//operator Type**() const			// cast Tab -> tableau-2D
//    	{ return ptr2; }			// DEBUG : cast ** interdit en ANSI ?
// operator Type**()				// cast Tab -> tableau-2D
//    	{ return ptr2; }



// ---------------------------------------------------------------------------
void charge_raw(char* nom, int dim_i=DIM_INDEFINIE, int dim_j=DIM_INDEFINIE);
void sauve_raw(char* nom);

 void charge_pgm(char *nom,int debug=1);

void sauve_pgm
	(
	 char *nom,
	 int debug	   = 1,
//	 char *ext = "",
	 char *commentaire = "JMarc Odobez - Created by PGM-library",
	 char *commentaire2= "",
	 char *commentaire3= ""
	);

void charge_ccett(char *nom);
void sauve_inr(char *nom);

void charge(char* nom, int dim_i=DIM_INDEFINIE, int dim_j=DIM_INDEFINIE);
void charge2(char* nom, int dim_i=DIM_INDEFINIE, int dim_j=DIM_INDEFINIE);

 void affiche(char Msg[])
   {
     cout<<Msg<<endl;
     cout<<inf1<<" "<<sup1<<" "<<inf2<<" "<<sup2<<endl;
   }
 

};








// DEFINITION DES FONCTIONS MEMBRES DE LA CLASSE Tab<Type>
// ***************************************************************************
template<class Type>
Tab<Type>::Tab(int dim_i, int dim_j)
{
#ifdef DEBUG_TAB_HH
 num_Tab = ++count_Tab;
 cout<<"Tab (no "<<num_Tab<<"): construit Tab("<<dim_i<<","<<dim_j<<")"<<endl;
#endif


 (*this).alloue_partie_dyn(0,dim_i-1,0,dim_j-1);
}



// ***************************************************************************
template<class Type>
Tab<Type>::Tab(int inf_i, int sup_i, int inf_j, int sup_j)
{
#ifdef DEBUG_TAB_HH
 num_Tab = ++count_Tab;
 cout<<"Tab (no "<<num_Tab<<"): construit Tab("<<inf_i<<".."<<sup_i<< "," <<inf_j<<".."<<sup_j<<")"<<endl;
#endif

 (*this).alloue_partie_dyn(inf_i,sup_i,inf_j,sup_j);
}



// ***************************************************************************
template<class Type>
Tab<Type>::Tab(int dim_i, int dim_j, Type val_init)
{
#ifdef DEBUG_TAB_HH
 num_Tab = ++count_Tab;
 cout<<"Tab (no "<<num_Tab<<"): construit Tab("<<dim_i<<","<<dim_j<<") + recopie "<<endl;
#endif

 (*this).alloue_partie_dyn(0,dim_i-1,0,dim_j-1);
 (*this).init(val_init);
}



// ***************************************************************************
template<class Type>
Tab<Type>::Tab(int dim_i, int dim_j, Type* p)
{
#ifdef DEBUG_TAB_HH
 num_Tab = ++count_Tab;
 cout<<"Tab (no "<<num_Tab<<"): construit Tab("<<dim_i<<","<<dim_j<<") + recopie tableau[]"<<endl;
#endif

 (*this).alloue_partie_dyn(0,dim_i-1,0,dim_j-1);

 int	n   = dim1*dim2;
 Type	*p1 = (Type *)(*this);			// utilise le cast Tab -> pointeur-1D

 for(int i=0; i<n; i++)
   *p1++ = *p++;				// recopie p[] dans Tab
}



// ***************************************************************************
template<class Type>				// constructeur par recopie
Tab<Type>::Tab(const Tab<Type>& tab2)
{
#ifdef DEBUG_TAB_HH
 num_Tab = ++count_Tab;
 cout<<"Tab (no "<<num_Tab<<"): construit copie Tab("<<tab2.inf1<<".."<<tab2.sup1<< "," <<tab2.inf2<<".."<<tab2.sup2<<")"<<endl;
#endif

 (*this).alloue_partie_dyn(tab2.inf1, tab2.sup1, tab2.inf2, tab2.sup2);

 int	n   = dim1*dim2;
 Type	*p1 = (Type *)(*this)+(*this).inf2,	// utilise le cast Tab -> pointeur-1D
	*p2 = (Type *)tab2   +tab2.inf2;

 for(int i=0; i<n; i++)
   *p1++ = *p2++;				// recopie tab2 dans Tab
}



// ***************************************************************************
template<class Type>
Tab<Type>& Tab<Type>::operator=(const Tab<Type>& tab)
{
#ifdef DEBUG_TAB_HH
  	cout<<"Tab: affectation"<<endl;
#endif

 // Rem: le cas idiot A=B ou ni A ni B n'ont encore de partie dynamique
 //      alloue n'a pas ete considr (et planterait ici...)


 if(this != &tab)
    {if(   inf1!=tab.inf1 || sup1!=tab.sup1
	|| inf2!=tab.inf2 || sup2!=tab.sup2)
	{
	 (*this).libere_partie_dyn();
     	 (*this).alloue_partie_dyn(tab.inf1, tab.sup1, tab.inf2, tab.sup2);
	}

     int   n  = dim1*dim2;
     Type *p1 = (Type *)(*this)+(*this).inf2,	// utilise le cast Tab -> pointeur-1D
	  *p2 = (Type *)tab    +tab.inf2;


     for(int i=0; i<n; i++)
       *p1++ = *p2++;
    }
 return *this;
}



// ***************************************************************************
template<class Type>
void Tab<Type>::dimensionne(int dim_i, int dim_j)
{
#ifdef DEBUG_TAB_HH
 cout<<"Tab: dimensionne Tab("<<dim_i<<","<<dim_j<<")"<<endl;
#endif

 if( (dim_i!=dim1) || (dim_j!=dim2) || (inf1 != 0) || (inf2 != 0)){
   (*this).libere_partie_dyn();
   (*this).alloue_partie_dyn(0,dim_i-1,0,dim_j-1);
 }
 return;
}

// ***************************************************************************
template<class Type>
void Tab<Type>::dimensionne(int inf_i, int sup_i,int inf_j, int sup_j)
{
#ifdef DEBUG_TAB_HH
 cout<<"Tab: dimensionne Tab("<<inf_i<<","<<sup_i<<";"<<inf_j<<","<<sup_j<<")"<<endl;
#endif

 if( (sup_i!=sup1) || (sup_j!=sup2) || (inf1 != inf_i) || (inf2 !=inf_j )){
   (*this).libere_partie_dyn();
   (*this).alloue_partie_dyn(inf_i,sup_i,inf_j,sup_j);
 }
 return;
}



// ***************************************************************************
template<class Type>
void Tab<Type>::init(Type val_init)
{
#ifdef DEBUG_TAB_HH
 cout<<"Tab: initialisation"<<endl;
#endif

 int   n = dim1*dim2;
 if(n>0){
   Type *p = (Type *)(*this)+(*this).inf2;	// utilise le cast Tab -> pointeur-1D
   for(int i=0; i<n; i++)
     *p++ = val_init;
 }
 
}


template<class Type>
void Tab<Type>::init(int dim_i, int dim_j, Type val_init)
{
#ifdef DEBUG_TAB_HH
 cout<<"Tab: dimensionne Tab("<<dim_i<<","<<dim_j<<") + init"<<endl;
#endif

 (*this).dimensionne(dim_i,dim_j);
 (*this).init(val_init);
 
}

template<class Type>
void Tab<Type>::initfromimage(int dim_i, int dim_j, Type* image,int ManageImageDestroy)
{
  (*this).libere_partie_dyn();
  (*this).alloue_partie_dyn_from_image(image,0,dim_i-1,0,dim_j-1);
  if(ManageImageDestroy==1){
    MemAllocated=AllAllocated;
  }
  
}



// ***************************************************************************
template<class Type>
Tab<Type> & Tab<Type>::operator<<(Tab<Type>& tab)
{
#ifdef DEBUG_TAB_HH
  	cout<<"Tab: transfert (recopie partielle)"<<endl;
#endif

  (*this).permute(tab);
  return tab;					// retourne donc ce qu'etait (*this)
}



// ***************************************************************************
template <class Type>
void Tab<Type>::charge_raw(char* nom, int ti, int tj)	// ti,tj optionnels
							// =DIM_INDEFINIE si absents
{
 FILE* f = try_fopen(nom,"r");
#ifdef Msg_ES
 cout<<"Lecture de "<<nom<<" ..."<<endl;
#endif


 if( ti!=DIM_INDEFINIE || tj!=DIM_INDEFINIE )	// si dimensions transmises
   if( dim1!=ti || dim2!=tj )
	{
	 (*this).libere_partie_dyn();
     	 (*this).alloue_partie_dyn(0,ti-1,0,tj-1);
	}


 fseek(f,0L,SEEK_END);				// va  la fin du fichier
 while( ftell(f) != dim1*dim2*(int)sizeof(Type) )
	{
	 (*this).libere_partie_dyn();
	 cerr<<"  Pas de memoire allouee pour cette taille de fichier-image"<<endl;
         cerr<<"  Entrez ses dimensions lignes,colonnes: " ;
         cin>>dim1>>dim2;
     	 (*this).alloue_partie_dyn(0,dim1-1,0,dim2-1);
	}


 rewind(f);					// revient au debut et charge
 try_fread( (char*)&(ptr2[inf1][inf2]),sizeof(Type),dim1*dim2,f,nom);
 fclose(f);
}



// ***************************************************************************
template <class Type>
void Tab<Type>::sauve_raw(char* nom)
{
 FILE* f = try_fopen(nom,"w");
#ifdef Msg_ES
 cout<<"Ecriture de "<<nom<<" ..."<<endl;
#endif

 try_fwrite( (char*)&(ptr2[inf1][inf2]),sizeof(Type),dim1*dim2,f,nom);

 fclose(f);
}



// ***************************************************************************
template <class Type>				// gnralis a tous le types
void Tab<Type>::charge_pgm(char* nom,int debug)
{
 FILE* f = try_fopen(nom,"r");
 int  ti,tj;
 int  size,good_size;
 char c, marque[2+1];				// 2 carac. + 0 terminal



 // LECTURE DE L'ENTETE PGM
 // =======================
 fscanf(f,"%2s\x0A%c", marque,&c);		// absorbe P5+'CR' et lit car. suivant
 if( marque[0]!='P' || marque[1]!='5')
	{cerr<<"Abandon: Pas d'entete PGM dans "<<nom<<endl;    exit(-1);}


 // ABSORBE LES n LIGNES DE COMMENTAIRE (CONSECUTIVES)
 // ==================================================
 while( c=='#' )
   {fscanf(f,"%*[^\x0A]\x0A%c",&c); 		// absorbe commentaire ($0A inclus)
   }
 fseek(f,-1L,SEEK_CUR);				// recule pour se remettre sur c


 // LECTURE DES INFOS IMAGE
 // =======================
 fscanf(f," %d %d",&tj,&ti);			// lecture des infos-image
 if( sizeof(Type)==1 )
	{good_size =255;
   	 fscanf(f," %d\x0A",&size);		// PGM normal (8 bits): niveau gris max
  	}
 else	{good_size = sizeof(Type);
   	 fscanf(f," %d bytes\x0A",&size);	// PGM generalis: taille des elements
	}
 if( size != good_size )
	{cerr<<"Abandon: elements de taille incorrecte dans "<<nom<<endl;
	 exit(-1);
	}

#ifdef Msg_ES
 if(debug>0){
	cout<<"Lecture de "<<nom<<" ... ("<<ti<<" x "<<tj<<")"<<endl;
 }
#endif


 if( dim1!=ti || dim2!=tj )
	{
	 (*this).libere_partie_dyn();
     	 (*this).alloue_partie_dyn(0,ti-1,0,tj-1);
	}


 // LECTURE DES PIXELS
 // ==================
 try_fread( (char*)&(ptr2[inf1][inf2]),
	    sizeof(Type),dim1*dim2,f,nom);

 fclose(f);

}



// ***************************************************************************
template <class Type>				// gnralis a tous le types
void Tab<Type>::sauve_pgm(char *nom,
			   int debug, 
//								  char *ext,    // pour indice dans un nom (optionnel)
			   char *commentaire,	// commentaires (optionnels)
			   char *commentaire2,
			   char *commentaire3
			 )
{
 FILE* f;
/*
 char nom_f[256];

 if(i==-1)	sprintf(nom_f,"%s",nom);	// parametres optionnels non fournis
 else		sprintf(nom_f,"%s%d%s",nom,i,ext);
*/

 f = try_fopen(nom,"w");
#ifdef Msg_ES
 if(debug>0){
	cout<<"Ecriture de "<<nom<<" ...";
	fflush(stdout);
}
#endif



 // ECRITURE DE L'ENTETE PGM
 // =========================
 fprintf(f,"P5\x0A");					// marque PGM

 // ecrit lignes de commentaire non-vides
 if( commentaire[0] !='\0' )	fprintf(f,"# %s\x0A",commentaire);
 if( commentaire2[0]!='\0' )	fprintf(f,"# %s\x0A",commentaire2);
 if( commentaire3[0]!='\0' )	fprintf(f,"# %s\x0A",commentaire3);

 fprintf(f,"%d %d\x0A", dim2, dim1);			// dimensions
 if( sizeof(Type)==1 )
      fprintf(f,"%d\x0A",255);				// niveau de gris maximum
 else fprintf(f,"%d bytes\x0A",(int)sizeof(Type));	// longueur des lments


 // ECRITURE DES ELEMENTS
 // =====================
 try_fwrite( (char*)&(ptr2[inf1][inf2]),sizeof(Type),dim1*dim2,f,nom);

#ifdef Msg_ES
 if(debug>0){
 cout<<"  terminee."<<endl;
	fflush(stdout);
}
#endif

 fclose(f);
}


/*
// ***************************************************************************
template <class Type>
void Tab<Type>::charge(char* nom, int ti, int tj)	// ti,tj optionnels
							// =TAB_INDEFINI si absents
{
 FILE* f = try_fopen(nom,"r");
 char marque[2+1];					// 2 carac. + 0 terminal


 // TESTE ENTETE
 // ============
 fscanf(f,"%2s", marque);
 fclose(f);

 if( marque[0]=='P' && marque[1]=='5' )
	(*this).charge_pgm(nom);
 else	(*this).charge_raw(nom,ti,tj);
}
*/





// ******************************* IRISA ***********************************************
// tab.cc
//
// version 27.11.95   Yann RICQUEBOURG, Laurent BONNAUD
// *************************************************************************************







// ***************************************************************************
#define fwrite_short(v,f)	{short s=(short)v; fwrite( (char*)&s,sizeof(s),1,f); }
#define fwrite_octet(v,f)	{octet o=(octet)v; fwrite( (char*)&o,sizeof(o),1,f); }
#define fwrite_float(v,f)	{float x=(float)v; fwrite( (char*)&x,sizeof(x),1,f); }

template <class Type>
void Tab<Type>::sauve_inr(char *nom)		// valable seulement pour Type=octet
{
 FILE* f = try_fopen(nom,"w");

#ifdef Msg_ES
 cout<<"Ecriture de "<<nom<<" ..."<<endl;
#endif


 // ECRITURE DE L'ENTETE INRIMAGE
 // =============================
 fwrite_short(dim2,f);
 fwrite_short(dim1,f);
 fwrite_octet(sizeof(octet),f);
 fwrite_octet(0,f);
 fwrite_short(1,f);
 fwrite_short(1,f);
 fwrite_short(dim2,f);

 fwrite_float(0,f);
 fwrite_float(0,f);
 fwrite_float(0,f);
 fwrite_short(0,f);

{int n;
  for(n=0;  n<102;  n++)	fwrite_octet(0,f);
  for(n=0;  n<128;  n++)	fwrite_octet(0,f);
}


 // ECRITURE DES PIXELS
 // ===================
 try_fwrite( (char*)&(ptr2[inf1][inf2]),sizeof(octet),dim1*dim2,f,nom);

 fclose(f);
}






// ***************************************************************************
// charge l'image dsigne a l'interieur d'un fichier squence <nom-seq>
//
// dsignation:	<nom-seq>.I<n>	= image n, pleine resolution
//		<nom-seq>.i<n>	= image n, resolution/2 (en ligne et en colonne)
//		<nom-seq>.T<zn>	= trame n, pleine resolution
//		<nom-seq>.t<n>  = trame n, resolution colonne/2 (redevient proportionn)

template <class Type>
void Tab<Type>::charge_ccett(char *nom)		// valable seulement pour Type=octet
{
  char	entete[128],	/* 128 1ers octets de l'entete du fichier sequence 	*/
	val[5];		/* decode valeurs sur 4 caracteres (0 terminal en fin)  */
  int	ncol,		/* nb de colonnes par TRAME dans la sequence   		*/
	nlig,		/* nb de lignes     ..      				*/
	nima;		/* nb d'images (=paire de trames) 			*/
  long	lg_entete,	/* longueur effective de l'entete (multiple de ncol)	*/
	lg_trame;	/* longueur d'une trame 				*/




  // RECUPERE 'VRAI' NOM DU FICHIER = SANS TERMINAISON
  // =================================================
  chaine term 	= suffixe_ch(nom);		// recupere terminaison .???
  chaine seq  	= chaine(nom)-term;			// fichier sequence proprement dit

  FILE * f = try_fopen(seq,"r");



  // LIT INFOS DE L'ENTETE
  // =====================
  try_fread(entete,1,128,f,seq);		/* lecture du debut de l'entete */

  if( strncmp(entete,"IMAG",4)!=0 || entete[5]!='2')	/* verifie IMAG version 2 */
     	{fprintf(stderr,"Abandon: Pas d'entete sequence (IMAG v2) dans %s\n", (char*)seq);
	 exit(-1);
  	}
  strncpy(val,entete+76,4); val[4]='\0';  ncol=atoi(val);
  strncpy(val,entete+80,4); val[4]='\0';  nlig=atoi(val);
  strncpy(val,entete+84,4); val[4]='\0';  nima=atoi(val);
  lg_entete = ncol*(1 + 512/(ncol+1) );		/* longueur effective d'entete */
  lg_trame  = ncol*nlig;



  // ALLOCATIONS
  // ===========
  int	w,h,					// dimensions de l'image resultat
  	n = valeur_ch(reste_ch(term,2));	// recupere le numero demand [1,max]

  switch(term[1]) {
  case 'T':	w=ncol;   h=nlig;    n--;	   		break;
  case 't':	w=ncol/2; h=nlig;    n--;			break;
  case 'i':	w=ncol/2; h=nlig;    n=(n-1)*2;			break;
  case 'I': /* mode par defaut */
  default :	w=ncol;   h=nlig*2;  n=(n-1)*2;
  }

  if( n<0 || n>=nima*2 )  // n est desormais un indice de trame dans [0,2.nima[
     	{fprintf(stderr, "En dehors des limites du fichier sequence.\n");
      	 exit(-1);
     	}

  (*this).dimensionne(h,w);
#ifdef Msg_ES
  cout<<"Lecture de "<<nom<<" ... ("<<h<<" x "<<w<<")"<<endl;
#endif



  octet * ligne = (octet *)malloc(ncol*sizeof(char));		// buffer lecture
  if( ligne==NULL)
   {fprintf(stderr, "Reservation memoire impossible.\n");
    exit(-1);
   }


  // LECTURE DES PIXELS
  // ==================
  rewind(f); fseek(f, lg_entete + n*lg_trame, SEEK_SET);
  octet * ptr = (octet *)(*this);			// pointe sur l'image


  switch(term[1]) {
  case 'T':
	try_fread( (char*)ptr,1,nlig*ncol, f,seq);
						break;
  case 't':
  case 'i':
	{int l,c;					// indices lignes,colonnes
	 octet * p=ptr;					// pointe sur l'image

	 for(l=0; l<h; l++)
	  {try_fread( (char*)ligne,1,ncol, f,seq);
	   for(c=0; c<w; c++)
		*p++=ligne[c*2];			// divise resolution
	  }
	}
						break;
  case 'I':
  default :
	{octet * p;
         int l;

	 for(p=ptr,l=0;       l<nlig;  l++,p+=ncol*2)	// charge trame paire
	   try_fread( (char*)p,1,ncol, f,seq);
	 for(p=ptr+ncol,l=0;  l<nlig;  l++,p+=ncol*2)	// charge trame impaire
	   try_fread( (char*)p,1,ncol, f,seq);
	}
  }


  free( (char*)ligne );
  fclose(f);
}



// ***************************************************************************
template <class Type>
void Tab<Type>::charge(char* nom, int ti, int tj)	// ti,tj optionnels
							// =TAB_INDEFINI si absents
{
 chaine vrai_nom;					// necessaire pour l'appel
 FILE* 	f = try_fopen(nom,"r",vrai_nom,FAUX);		// FAUX => pas d'exit


 if( f==NULL )						// fichier inexistant
	(*this).charge_ccett(nom);
 else
 {
 // TESTE ENTETE
 // ============
 char marque[2+1];					// 2 carac. + 0 terminal

 fscanf(f,"%2s", marque);
 fclose(f);

 if( marque[0]=='P' && marque[1]=='5' )
	(*this).charge_pgm(nom);
 else	(*this).charge_raw(nom,ti,tj);
 }
}











#endif	// TAB_HH
