// ************************************************************************
// macros.h
//
// version
// ************************************************************************



#ifndef MACROS_HH
#define MACROS_HH


#include <math.h>	 // for M_PI
#include <iostream.h>
#include <ctype.h>       // for isspace()
#include <stdio.h>



//=====	CONSTANTS ==========================================================

#define FAUX		0
#define VRAI		1
#define FALSE		0
#define TRUE		1
#define PI		((double) M_PI)		// cf math.h
#define PIs2		((double) M_PI/2.)	// cf math.h

//=====	TYPES ===============================================================

typedef unsigned char 	octet;
typedef int		booleen;


// ==============================================

#include "ioascii.h"

//======================================================================

inline  void Tbooleen(ostream & out,booleen B)
{
  if(B) {out<<" VRAI ";}
  else {out<<" FAUX ";}
}

//======================================================================

inline int MySign(int x)
{
  if( x>0 ) 	return(+1);
  else
    if( x<0 ) 	return(-1);
    else 		return(0);       // if nul, returns 0 
}


inline int Mysign(double x)
{
  if( x>0.0 ) 	return(+1);
  else
    if( x<0.0 ) 	return(-1);
    else 		return(0);	// if nul, returns 0 
}


// ***************************************************************************
inline double MyVabs(double x)		     // over definition : MyVabs(reel)
{
 if( x<0.0 ) 	return(-x);
 else 		return(x);
}


inline int MyVabs(int x)		     // over definition : MyVabs(reel)
{
 if( x<0 ) 	return(-x);
 else 		return(x);
}


// ***************************************************************************
template <class Type>
inline Type MyMax(Type a, Type b)
{
 if(a>b)	return a;
 else		return b;
}

template <class Type>
inline Type MyMin(Type a, Type b)
{
 if(a<b)	return a;
 else		return b;
}


// ***************************************************************************
template <class Type>
inline int MyArrondi(Type x)		// decimal -> nearest integer
{
 if(x>=0)	return (int)(x+0.5);
 else		return (int)(x-0.5);
}

// ***************************************************************************

// ***************************************************************************
inline booleen MyNul(double x,double eps=0.001)
{return( (MyVabs(x)<eps)? VRAI : FAUX );
}

inline booleen MyEqual(double x, double y,double eps=0.001)
{return( MyNul(x-y) );
}

// ***************************************************************************
template <class Type>
inline void MyPermutation(Type & a, Type & b)
{Type	t = a;
	a = b;
	b = t;
}



#endif	// MACROS_HH
