#ifndef IPCV_SEQIMAGE_LISTOFFILES_INC
#define IPCV_SEQIMAGE_LISTOFFILES_INC

#include "ip_SeqImageListOfFiles.h"
#include "ipcv_BaseSeqImage.h"
#include "ipcv_MultiImage.h"

namespace ImageProcessing {

  //-----
  
  /** 
  //===================================================
  // 
  //    Sequence representation
  //

  template <class Type>
    class ipcv_SeqImageListOfFiles  :
    OK, same as ip_SeqImageListOfFiles, but using the ipcv_Image 
    representation.
    
    Note :
    only the types :
      - uchar
      - ipColorElement8u
    can be used, as only the loading in such image format is defined

    Here, the sequences of images (of any size) are read from a file
    containing the names of the image files.

      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */

  //===================================================
  template <class Type>
    class ipcv_SeqImageListOfFiles :
    virtual public ipcv_BaseSeqImage<Type>,
    virtual public ip_SeqImageListOfFiles<Type>, 
    virtual public ipcv_MultiImage<Type> {
      public:

      // the number of images NberImage represents the number of frames 
      // in the past (with respect to current frame) that is stored
      // and that can be accessed without reloading
      //
    ipcv_SeqImageListOfFiles<Type>(int NberImage,char * filename) :
            ipcv_MultiImage<Type> (NberImage), ip_SeqImageListOfFiles<Type>(filename) {
    }
 	
      
    virtual ipcv_Image<Type> * previousCvImage(int i){
      return (ipcv_Image<Type> *)ip_SeqImageListOfFiles<Type>::previousImage(i);
    }

      virtual ipcv_Image<Type> * currentCvImage(){
	return (ipcv_Image<Type> *)ip_SeqImageListOfFiles<Type>::currentImage();
      }

      virtual bool             firstImage(){
	return ip_SeqImageListOfFiles<Type>::firstImage();
      }
      
      virtual bool             nextImage(){
	return ip_SeqImageListOfFiles<Type>::nextImage();
      }

      virtual ~ipcv_SeqImageListOfFiles(){}

  };

   
}

#endif
