#ifndef IPCV_SEQIMAGEFILE_INC
#define IPCV_SEQIMAGEFILE_INC

#include "ip_SeqImageFile.h"
#include "ipcv_BaseSeqImage.h"
#include "ipcv_MultiImage.h"

namespace ImageProcessing {

  //-----
  
  /** 
  //===================================================
  // 
  //    Sequence representation
  //

  template <class Type>
    class ipcv_SeqImageFile  :
    OK, same as ip_SeqImageFile, but using the ipcv_Image 
    representation.
    
    Note :
    only the types :
      - uchar
      - ipColorElement8u
    can be used, as only the loading in such image format is defined


      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */

  //===================================================
  template <class Type>
    class ipcv_SeqImageFile :
    virtual public ipcv_BaseSeqImage<Type>,
    virtual public ip_SeqImageFile<Type>, 
    virtual public ipcv_MultiImage<Type> {
      public:

      // the number of images NberImage represents the number of frames 
      // in the past (with respect to current frame) that is stored
      // and that can be accessed without reloading
      //
      ipcv_SeqImageFile(int NberImage,char * oneName,int first,int last,int step,
			TypeNumberOutput _Type=FixedLength) :
	ipcv_MultiImage<Type> (NberImage) {
	m_iFirst=first;
	m_iLast=last;
	m_iStep=step;
	m_cGenericName=     ip_ImageName (oneName,_Type);  // 
      }
 	
      
      virtual ipcv_Image<Type> * previousCvImage(int i){
	return (ipcv_Image<Type> *)ip_SeqImageFile<Type>::previousImage(i);
      }

      virtual ipcv_Image<Type> * currentCvImage(){
	return (ipcv_Image<Type> *)ip_SeqImageFile<Type>::currentImage();
      }

      virtual bool             firstImage(){
	return ip_SeqImageFile<Type>::firstImage();
      }
      
      virtual bool             nextImage(){
	return ip_SeqImageFile<Type>::nextImage();
      }

      virtual ~ipcv_SeqImageFile(){}

  };

   
}

#endif
