#ifndef IPCV_HISTOGRAM_TEMPLATE_INC
#define IPCV_HISTOGRAM_TEMPLATE_INC

#include "general.h"

// open cv
#include "cv.h"
#include "cvtypes.h"

#include "ipcv_MultiImage.h"

namespace ImageProcessing {

typedef enum ipcv_HistDistance {
    HIST_DISTANCE_CORREL = CV_COMP_CORREL,
    HIST_DISTANCE_CHISQR = CV_COMP_CHISQR,
    HIST_DISTANCE_INTERSECT = CV_COMP_INTERSECT,
    HIST_DISTANCE_BHATACHARYYA = 3,
    HIST_DISTANCE_HAUSSDORF = 4,
    HIST_DISTANCE_UNKNOWN
} ipcv_HistDistance;


//-----

/** Provides store object for an histogram template.

    The general histogram is made out of several histograms 
    at several positions.
    


    @author Jean-Marc Odobez (Jean-Marc.Odobez@idiap.ch)
    @author Daniel Gatica-Perez (gatica@idiap.ch)
*/

  class ipcv_HistogramTemplate
  {  

    public:
    CvHistogram     **m_pHt;// Arrays of histograms (one for each position)
    int              m_iNbBands;      // Number of bands in the images
    int              m_iNbPositions;  // Number of positions/boundingboxes
    int              m_iDistanceType; // Distance between histogram to 


    ipcv_HistogramTemplate();
    //-----
    ipcv_HistogramTemplate(int _NbPos,int _NbDims,int *_Dims,float **ranges,
			   bool _unif=false);
    //
    ipcv_HistogramTemplate(int _NbPos,int _NbDims,int _NBinPerBand,
			   float _minRange,float _maxRange);

    //-----
    int   nbPositions(){return m_iNbPositions; }
    //-----
    int   nbDimensions(){ return m_iNbBands; }
    //-----
    bool  isUniform(){ 
      if(m_pHt[0]->flags & CV_HIST_UNIFORM) return true; 
      else return false;
    }
    
    //-----
    // Number of bins per dimension; if not specified
    // total number of bins (per position)
    int   nbBins(int k=-1);
    
    //-----
    virtual void deleteHistogram();
    
    //-----
    virtual void createHistogram(int _NbPos,int _NbDims,int *_Dims,float **ranges,
				 bool _unif=false);
    
    //-----
    virtual void createHistogramUniform(int _NbPos,int _NbDims,int _NbBin,
					float _minRange,float _maxRange);  

    // create a copy with same characteristics
    //-----
    virtual ipcv_HistogramTemplate * createCopy(bool InitZero=false);
    
    //-----
    virtual void setDistanceType(ipcv_HistDistance _dist_type);
    //-----
    
    virtual float distance(ipcv_HistogramTemplate *H);

    //-----
    virtual bool sameTemplate(ipcv_HistogramTemplate *H);

    //-----
    void display(char *comment);
    
    

    //-----
    virtual void load(char *_name);
    //-----
    virtual void save(char *_name);
    //-----
  };

}

#endif // IPCV_HISTOGRAM_TEMPLATE_INC
