#include "ipcv_HistogramMeasurer.h"
#include "macros.h" // for MyArrondi


namespace ImageProcessing {

  //----
  // 
  bool  ipcv_HistogramMeasurer::computeHistogram(IplImage               **bands,
																 ipcv_HistogramTemplate *H,
																 ip_BoundingBox         *BBoxes,
																 bool                    Normalize)
  {
	 
    int i,b,N,N2;
    ip_BoundingBox  ImageBB;
    ip_BoundingBox  Work;
	 
	 int * m_pVolumeOfBoxes;
	 
    CvRect          ROI;
    
 
    if(H->m_iNbPositions>0)
      ImageBB.initPosAndSize(0,0,bands[0]->width,bands[0]->height);

    m_pVolumeOfBoxes = new int [H->m_iNbPositions];
	 

    N=0; N2=0;
    for(i=0;i<H->m_iNbPositions;i++){
      Work=BBoxes[i];
      N2+=Work.area();
      Work.intersection(ImageBB);    // crop to stay in image range
		
      //      Work.display("Work :"); fflush(stdout);
      m_pVolumeOfBoxes[i]=Work.area();

      N+=m_pVolumeOfBoxes[i];
      if(m_pVolumeOfBoxes[i]>0){
		  ROI.x=Work.m_iFirstColumn;
		  ROI.y=Work.m_iFirstLine;
		  ROI.width=Work.m_iWidth;
		  ROI.height=Work.m_iHeight;
		  for(b=0;b<H->m_iNbBands;b++){
			 cvSetImageROI(bands[b],ROI);
		  }
		  cvCalcHist(bands,H->m_pHt[i],0,0);
      }
    }
    // Normalize histogram to get a "full" multivariate histogram
	 if(Normalize){
		for(i=0;i<H->m_iNbPositions;i++)
		  cvNormalizeHist(H->m_pHt[i],(float)m_pVolumeOfBoxes[i]/N);
	 }
	 
	 delete [] m_pVolumeOfBoxes;
	 
    // we set a limit on the numbers of points we 
    // need (this should be compared with the total number
    // of bins in the template)
    if((double)N/(double)N2 < 0.5 || N < 50 )
      return false;
    else 
      return true;
  }

   
}

