#ifndef IPCV_CONTOUR_TEMPLATE_INC
#define IPCV_CONTOUR_TEMPLATE_INC

#include "general.h"

// open cv
#include "cv.h"
#include "cvtypes.h"


// from image_processing
#include "ipcv_MultiImage.h"
#include "ip_PixelAndPoint.h"
#include "ip_LineSegment.h"
#include "ip_ImageFeatureFunctions.h"
#include "ip_Shape.h"
#include "bf_DistributionReal.h"

//from bayes_image
#include "ip_ParsContourTracking.h"


using namespace Torch;

namespace ImageProcessing {

typedef enum ipcv_ContourMeasure {
  MEASURE_BLAKE = 0,
  MEASURE_UNKNOWN
} ipcv_ContourMeasure;


//-----

/** Provides data storage for a contour template
    (measures from a a set of normal lines to a contour)

    @author Jean-Marc Odobez (Jean-Marc.Odobez@idiap.ch)
    @author Daniel Gatica-Perez (gatica@idiap.ch)
*/

  class ipcv_ContourTemplate
  {  

    public:

    int             m_iNumberOfPoints;     // number of points on contour
    ip_Point       *m_pPointList;          // the list of points on shape
    bool           *m_pValidPoint;         // flag for valid points in contour
    ip_Point       *m_pNormalVectorList;   // the list of normal vectors
    ip_LineSegment *m_pNormalLineList;     // the pars of the normal lines
    int             m_iMeasureType;        // how measures are computed
    ip_Shape       *m_pShape;              // parameterized shape
    real            m_rLineLength;
    int             m_iNumOfPointsInLine;




    //-----
    ipcv_ContourTemplate();

    //-----
    ipcv_ContourTemplate(int numOfPoints, int measureType,
			 real lineLength, int numberOfPointsOnLine);

    //-----
    void create(int numOfPoints, int measureType,
		real lineLength, int numberOfPointsOnLine);

    //-----
    void validatePointsOnContour(int rows, int cols);

    //----- get the parameters for a line
    virtual void computeLineSegments(ip_Shape *pShape, int rows, int cols); 

    //---- computes the features
    virtual void computeEdgeFeatures(ip_Image<ip_ColorElement8u> *pImage,
				     int sigma, real threshold);
    
    //---- computes all features in one step
    virtual void extractEdgeFeatures(ip_Shape *pShape, int rows, int cols, 
				     ip_Image<ip_ColorElement8u> *pImage,
				     int sigma, real threshold);

    //----    
    virtual real computeLikelihood(bf_EvalDistReal *pProb);
 

    //----- can be used only after computing the line segments
    virtual void drawLineSegments(ip_Image<ip_ColorElement8u> & Ima,
				  ip_ColorElement8u color);

    //----- can be used only after computing the line segments
    virtual void drawLineSegments(ip_Image<ip_ColorElement8u> *pImage,
				  ip_ColorElement8u color);

    //----- can be used only after computing the line segments
    virtual void drawFeatures(ip_Image<ip_ColorElement8u> *pImage, 
			      ip_ColorElement8u color);

    //-----
    virtual void freeMemory(void);

    //-----
    virtual ~ipcv_ContourTemplate()
    {freeMemory(); printf("out ContourTemplate \n");}
 
  };

}

#endif // IPCV_CONTOUR_TEMPLATE_INC
