#ifndef IPCV_BASESEQIMAGE_INC
#define IPCV_BASESEQIMAGE_INC

#include "ipcv_Image.h"

namespace ImageProcessing {

  //-----
  
  /** 
  //===================================================
  // 
  //    Sequence representation
  //

  ---> Created classes :  

  template <class Type>
  ipcv_BaseSeqImage : basic class interface for 
                    reading interaces of sequences
  

    @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  //===================================================
  //
  //    class         ipcv_BaseSeqImage
  //
  //    Same as ip_BaseSeqImage, but returns ipcv images
  //
  //    The sequence holds N images of the specified type
  //    so that you can get the current one, and the previous
  //    ones.
  //    You can not perform any jump in this implementation
  //    
  //
  //    10-May-2002 : Initial setup
  //
  //===================================================

  //===================================================
  template <class Type>
    class  ipcv_BaseSeqImage {
    public:
    virtual ipcv_Image<Type> * currentCvImage()=0;
    virtual ipcv_Image<Type> * previousCvImage(int i)=0; // 0 = current, 1 -> t-1, 2 -> t-2...
    virtual bool             firstImage()=0;
    virtual bool             nextImage()=0;
   
    //  virtual ~ipcv_BaseSeqImage()=0;
    
  };

   
}

#endif
