#ifndef IP_SEQIMAGE_LISTOFFILES_INC
#define IP_SEQIMAGE_LISTOFFILES_INC

#include "ip_BaseSeqImage.h"
#include "ip_MultiImage.h"
#include "ip_LoadSaveImage.h"
#include "ip_ImageName.h"
#include "ioascii.h"

namespace ImageProcessing {

  //-----
  
  /** 
  //===================================================
  // 
  //    Sequence representation
  //

  template <class Type>
    class ip_SeqImageListOfFiles  :
    implements the BaseSeqImage using the ip_MultiImage representation
    (it is derived from ip_MultiImage so that it has the 
     properties also; note, however, that it is dangerous 
     to use them)
     Remark : it is still undefined (need newIpImage() to be defined)

    Here, the sequences of images (of any size) are read from a file
    containing the names of the image files.

    Note :
    only the types :
      - uchar
      - ipColorElement8u
    can be used, as only the loading in such image format is defined


      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */

  //===================================================
  template <class Type>
    class ip_SeqImageListOfFiles :
    virtual public ip_BaseSeqImage<Type>, 
    virtual public ip_MultiImage<Type>
    {
      // private:
    public:
      FILE   *m_pFp;  // pointer on the file containing the
      // image file names
      ip_FileName      m_cNameOfFile;
      
    public:
      ip_ImageName     m_cCurrentImageName;
      chaine           m_cDirectory;    // Not used currently
      int              m_iUseDirectory; // Not used currently
 
      int              m_iNumberRead;   // number of already read images;
      int              m_iCurrentIndex;
      
      //====================================================
      ip_SeqImageListOfFiles<Type>()
	{
	  m_pFp=NULL;
	}

      //====================================================
      ip_SeqImageListOfFiles<Type>(char *filename) :
	  m_cNameOfFile(filename)
	{
	  m_pFp=NULL;
	}
      

      //====================================================
      virtual ip_Image<Type> * currentImage(){
	if(m_iNumberRead>0)
	  return getIpImage(m_iCurrentIndex);
	else
	  return NULL;
      }

      //====================================================
      virtual ip_Image<Type> * previousImage(int i){ // 0 = current, 1 -> t-1, 2 -> t-2...
	int ind;
	if(m_iNumberRead>i){
	  ind = (nbBands()+m_iCurrentIndex-i)%nbBands();
	  //	  printf(" index cfor prev = %d \n",ind);
	  return getIpImage(ind);
	}
	else{
	  printf("WARNING : NUMBER OF READ IMAGES is below ");
	  printf(" the ancieninity asked for \n");
	  fflush(stdout);
	  return NULL;
	}
      }
	  
      //====================================================
      virtual bool           firstImage(){

	// WE OPEN THE FILE HERE
	if(m_pFp==NULL){
	  m_pFp=fopen(m_cNameOfFile.fullName(),"rb");
	  if(m_pFp==NULL){
	    printf("\nERROR : Unable to open file containing list of images");
	    printf("\n  (class ip_SeqImageListOfFiles)\n");
	    fflush(stdout);
	    exit(0);
	  }
	}
	else {
	  printf("\nERROR : file pointer to file containing list of images already allocated");
	  printf("\n  (class ip_SeqImageListOfFiles)\n");
	  fflush(stdout);
	  exit(0);
	}

	m_iNumberRead=0;
	m_iCurrentIndex=-1;
	return nextImage();
	
      }
      

      //========================================================
      virtual bool      nextImage(){

	char   name[128];
	int dummy;
	

	name[0]='\0';
	SupprimeCommDieseFile(m_pFp);
	fget_string(m_pFp,name,dummy);
	
	// Mget(m_pFp,name,"",128);
	if(name[0]!='\0'){
	  m_cCurrentImageName=ip_ImageName(name,FixedLength);
	  
	  printf("Current image = %s \n",m_cCurrentImageName.fullName());
	  fflush(stdout);
	  
	  m_iCurrentIndex = (m_iCurrentIndex+1)%nbBands();
	  LoadImage(*getIpImage(m_iCurrentIndex),
		    m_cCurrentImageName.fullName(),
		    m_cCurrentImageName.m_tType);
	  m_iNumberRead++;
	  setBand(m_iCurrentIndex);
	  return true;
	}
	else {
	  // check if reached end of file
	  int c = fgetc(m_pFp);
	  if(c==EOF){
	    printf("\nReach end of file : no more image file name\n");
	    fflush(stdout);
	    return false;
	  }
	  else {
	    printf("\nSomething strange : no more string to read, \n");
	    printf("   an it is not the end of file\n");
	    fflush(stdout);
	    return false;
	  }
	}
	return false;
	
      }
      
      //===================================================      
      virtual ~ip_SeqImageListOfFiles(){};
      
    };
  
}



#endif
