#ifndef IP_SEQIMAGEFILE_INC
#define IP_SEQIMAGEFILE_INC

#include "ip_BaseSeqImage.h"
#include "ip_MultiImage.h"
#include "ip_LoadSaveImage.h"
#include "ip_ImageName.h"

namespace ImageProcessing {

  //-----
  
  /** 
  //===================================================
  // 
  //    Sequence representation
  //

  template <class Type>
    class ip_SeqImageFile  :
    implements the BaseSeqImage using the ip_MultiImage representation
    (it is derived from ip_MultiImage so that it has the 
     properties also; note, however, that it is dangerous 
     to use them)
     Remark : it is still undefined (need newIpImage() to be defined)

    Note :
    only the types :
      - uchar
      - ipColorElement8u
    can be used, as only the loading in such image format is defined


      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */

  //===================================================
  template <class Type>
    class ip_SeqImageFile :
    virtual public ip_BaseSeqImage<Type>, 
    virtual public ip_MultiImage<Type>
    {
    public:

      ip_ImageName     m_cGenericName;  // 
      int              m_iFirst;        // images numbers
      int              m_iLast;
      int              m_iStep;
      int              m_iCurrent;

      int              m_iNumberRead;   // number of already read images;
      int              m_iCurrentIndex;
      
      virtual ip_Image<Type> * currentImage(){
	if(m_iNumberRead>0)
	  return getIpImage(m_iCurrentIndex);
	else
	  return NULL;
      }


      virtual ip_Image<Type> * previousImage(int i){ // 0 = current, 1 -> t-1, 2 -> t-2...
	int ind;
	if(m_iNumberRead>i){
	  ind = (nbBands()+m_iCurrentIndex-i)%nbBands();
	  //	  printf(" index cfor prev = %d \n",ind);
	  return getIpImage(ind);
	}
	else{
	  printf("WARNING : NUMBER OF READ IMAGES is below the");
	  printf(" the ancieninity asked for \n");
	  fflush(stdout);
	  return NULL;
	}
      }
	  
      virtual bool           firstImage(){
	m_iCurrent=m_iFirst;
	bool rep;
	if((m_iStep>0 && m_iCurrent<=m_iLast) ||(m_iStep<0 && m_iCurrent>=m_iLast) ){
	  m_cGenericName.m_iNumber=m_iCurrent;
	  LoadImage(*getIpImage(0),m_cGenericName.fullName(),m_cGenericName.m_tType);
	  m_iCurrentIndex=0;
	  m_iNumberRead=1;
	  rep=true;
	  setBand(m_iCurrentIndex);
	}
	else {
	  rep=false;
	  if(m_iStep>0){
	    printf("There is no first image to read : first number is below");
	    printf("  last number (and step is > 0) \n");
	  }
	  else {
	    printf("There is no first image to read : first number is above");
	    printf("  last number (and step is < 0) \n");
	  }
	  fflush(stdout);
	}
	return rep;
      }

      virtual bool      nextImage(){
	bool rep;
	m_iCurrent+=m_iStep;
	if((m_iStep>0 && m_iCurrent<=m_iLast) ||(m_iStep<0 && m_iCurrent>=m_iLast) ){
	  m_cGenericName.m_iNumber=m_iCurrent;
	  m_iCurrentIndex = (m_iCurrentIndex+1)%nbBands();
	  
	  //m_cGenericName.display();
	  //          printf("curr index = %d (image=%s)\n",m_iCurrentIndex,
	  //	 m_cGenericName.fullName()); fflush(stdout);
	  LoadImage(*getIpImage(m_iCurrentIndex),m_cGenericName.fullName(),
		    m_cGenericName.m_tType);
	  //printf("curr index = %d \n",m_iCurrentIndex);
	  //fflush(stdout);
	  
	  m_iNumberRead++;
	  rep=true;
	}
	else {
	  printf("Reached end of sequence \n");
	  rep=false;
	}
	setBand(m_iCurrentIndex);
	return rep;
      }
      
      virtual ~ip_SeqImageFile(){};
	
    };
   
}

#endif
