#include "ip_PlanarTranslationScaling2.h"

namespace ImageProcessing  {
  
  /** 
      Basic representation for 2D Translation + isotropic scaling.
      
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  
  /*
      xp = Tx + sx * dx
      yp = Ty + sy * dy

      image_point    = (xp,yp)
      initial_point  = (x,y)
      dx = x - origin.x
      dy = y - origin.y

      Tx = params[0];
      Ty = params[1];
      sx  = params[2];  
      sy  = params[3];  

      Reminder : x axis = column axis , y axis = line axis
  */

  //============================================================

  //-------- 
  ip_PlanarTranslationScaling2::ip_PlanarTranslationScaling2(){
    m_iNbParams=4;
    m_pParams=new real [m_iNbParams];
    m_pTx=&m_pParams[0]; m_pTy=&m_pParams[1];
    m_pScaleX=&m_pParams[2];
    m_pScaleY=&m_pParams[3];
  }

  //-------- 
  ip_PlanarTranslationScaling2::ip_PlanarTranslationScaling2(real *_params){
    m_iNbParams=4;
    m_pParams=new real [m_iNbParams];
    m_pTx=&m_pParams[0]; m_pTy=&m_pParams[1];
    m_pScaleX=&m_pParams[2];
    m_pScaleY=&m_pParams[3];
    setParams(_params);
  }

  //-------- 
  ip_PlanarTransformModel  ip_PlanarTranslationScaling2::planarModel(){
    return PLANAR_TRANSLATION_SCALING2; }

  //------------------------- 
  //- init to the null motion (identity transform)
  void  ip_PlanarTranslationScaling2::setIdentity(){
    *m_pTx=m_cOrigin.m_rX; *m_pTy=m_cOrigin.m_rY; *m_pScaleX=1.;*m_pScaleY=1.;
  }

  //--------
  void  ip_PlanarTranslationScaling2::changeOrigin(ip_Point new_origin){
    ip_Point p;
    p=imagePoint(new_origin);
    m_pParams[0]=p.m_rX; m_pParams[1]=p.m_rY;
    m_cOrigin=new_origin;
  }
  
  //-------
  void ip_PlanarTranslationScaling2::display(char * msg){
    printf("\n Translation : Tx(col) = %6.2f   Ty(line) = %6.2f ",
	   m_pParams[0],m_pParams[1]);
    printf("Scaling : Sx = %6.2f  Sy = %6.2f \n",
	   m_pParams[2],m_pParams[3]);
  }
  
  //-------
  ip_PlanarTranslationScaling2::~ip_PlanarTranslationScaling2() {
    delete [] m_pParams;
  }

}

