#ifndef IP_PLANAR_TRANSLATION_SCALING_HH
#define IP_PLANAR_TRANSLATION_SCALING_HH


#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <iomanip.h>

#include "ip_PlanarTransform.h" // for the definition of real

namespace ImageProcessing  {
  
  /** 
      Basic representation for 2D Translation + isotropic scaling.
      
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  
  /*
      xp = Tx + s * dx
      yp = Ty + s * dy

      image_point    = (xp,yp)
      initial_point  = (x,y)
      dx = x - origin.x
      dy = y - origin.y

      Tx = params[0];
      Ty = params[1];
      s  = params[2];  

      Reminder : x axis = column axis , y axis = line axis
  */

  //============================================================

  class  ip_PlanarTranslationScaling :
    virtual public ip_PlanarTransform
    {
    private:
      real *m_pTx,*m_pTy,*m_pScale;

    public:
      //-------- 
      ip_PlanarTranslationScaling();

      //-------- 
      ip_PlanarTranslationScaling(real *_params);

      //-------- 
      virtual ip_PlanarTransformModel  planarModel();

      //------------------------- 
      //- init to the null motion (identity transform)
      virtual   void  setIdentity();

      //--------
      virtual   void  changeOrigin(ip_Point new_origin);

      //--------
      // x = column number, y line number
      inline virtual ip_Point   imageReal(double x, double y){
	real dx=x-m_cOrigin.m_rX,dy=y-m_cOrigin.m_rY;
	return ip_Point(*m_pTx+*m_pScale*dx,*m_pTy+*m_pScale*dy);
      }

      //-------   dep =  displacement
      //  x = column number, y line number
      inline virtual ip_Vector depReal(real x, real y){
	real dx=x-m_cOrigin.m_rX,dy=y-m_cOrigin.m_rY;
	return ip_Point(*m_pTx+*m_pScale*dx-x,*m_pTy+*m_pScale*dy-y);
      }

      //-------
      virtual void display(char * msg="");
  
      //-------
      virtual ~ip_PlanarTranslationScaling();

};

}

#endif  // ip_PLANAR_TRANSLATION_SCALING_HH
