#include "ip_PlanarTranslation.h" 

namespace ImageProcessing  {
  
  /** 
      Basic representation for 2D Translation.
      
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  
  /*
      xp = Tx + x
      yp = Ty + y

      image_point    = (xp,yp)
      initial_point  = (x,y)

      Tx = params[0];
      Ty = params[1];
      
      Reminder : x axis = column axis , y axis = line axis
  */

  //============================================================

  //-------- 
  ip_PlanarTranslation::ip_PlanarTranslation(){
    m_iNbParams=2;
    m_pParams=new real [m_iNbParams];
  }

  //-------- 
  ip_PlanarTranslation::ip_PlanarTranslation(real *_params){
    m_iNbParams=2;
    m_pParams=new real [m_iNbParams];
    setParams(_params);
  }

  //-------- 
  ip_PlanarTransformModel  ip_PlanarTranslation::planarModel(){
    return PLANAR_TRANSLATION; 
  }

  //------------------------- 
  //- init to the null motion (identity transform)
  void  ip_PlanarTranslation::setIdentity(){
    m_pParams[1]=0.; 	m_pParams[0]=0.;
  }

  //--------
  void  ip_PlanarTranslation::changeOrigin(ip_Point new_origin){
    // representation not affected by change of origin
  }
  
  //-------
  void ip_PlanarTranslation::display(char * msg){
    printf("\n Translation : Tx(col) = %6.2f   Ty(line) = %6.2f \n",
	   m_pParams[0],m_pParams[1]);
  }
  
  //-------
  ip_PlanarTranslation::~ip_PlanarTranslation() {
    delete [] m_pParams;
  }

}

