#ifndef IP_PARS_CONTOUR_TRACKING_INC
#define IP_PARS_CONTOUR_TRACKING_INC

#include "general.h"


namespace ImageProcessing {

//-----

/** Miscellaneous parameters that are needed for doing tracking
    based on contour representation 

    @author Jean-Marc Odobez (Jean-Marc.Odobez@idiap.ch)
    @author Daniel Gatica-Perez (gatica@idiap.ch)

*/


/***************************************************
 parameters for the search lines
***************************************************/	      			  

#define ORIGINALSIZE 0

#if ORIGINALSIZE>0

#define NUMBER_SEARCH_LINES   32
#define SEARCH_LINE_LENGTH    30         // the total length of the line
#define POINTS_IN_SEARCH_LINE SEARCH_LINE_LENGTH
#define SEARCH_LINE_SIGMA     7.5          // ideally: sigma = (length/2)/2
#define MIN_DIST_DEF          15        // when no features are detected
                                         // MIN_DIST_DEF = SEARCH_LINE_LENGTH/2
#else

#define NUMBER_SEARCH_LINES   16
#define SEARCH_LINE_LENGTH    20         // the total length of the line
#define POINTS_IN_SEARCH_LINE SEARCH_LINE_LENGTH
#define SEARCH_LINE_SIGMA     5          // ideally: sigma = (length/2)/2
  //#define SEARCH_LINE_SIGMA     3          // ideally: sigma = (length/2)/2
#define MIN_DIST_DEF          SEARCH_LINE_LENGTH/2   // when no features are detected
                                                    // MIN_DIST_DEF = SEARCH_LINE_LENGTH/2

#endif

/***************************************************
 parameters for the distribution for contour likelihood
***************************************************/	
#define K_DISTRIBUTION        1          //K = q *\lambda


/***************************************************
 parameters for the dynamic model
***************************************************/	
#define VAR_TRANSLATION       4         //originally: 3 
#define VAR_SCALING           0.0001    
  //#define VAR_SCALING           0.00001    
#define MINIMUM_SCALING       0.5
#define MAXIMUM_SCALING       2.3 


/***************************************************
 parameters for the tracker
***************************************************/	
#define NUMBER_OF_PARTICLES   1000
#define NUM_ITER_FOR_SAVING   1
#define WEIGHT_PERCENTAGE     0.7        //usual: 0.5 or even less to see more particles
 


}

#endif // IP_PARS_CONTOUR_TRACKING_INC

