/* 
------------------------------------------------------------------------
_Institution : IDIAP
------------------------------------------------------------------------
_Module_Name : 

_Description : 

_Call :        

_System  : Unix
_Remarks : None

_Author : Jean-Marc Odobez
_Revisions History:

------------------------------------------------------------------------
_end
*/

#include "ip_LoadSaveImage.h"
#include "MyLoadSaveImageT.h"
#include "StringClass.h"

namespace ImageProcessing {

  //---------------------------------------
  ip_ImageType   ImType(chaine c)
  {
    //    cout<<c<<endl;
    if(c==chaine(".pgm")) return ip_PGM;
    else if(c==chaine(".pnm")) return ip_PNM;
    else if(c==chaine(".ppm")) return ip_PPM;
    else if(c==chaine(".bmp")) return ip_BMP;
    return ip_NoImageType;
  }
  
  //=======================================================
  //
  //  On pourrait faire bcp plus court si l'on avait
  //  definit les fonctions de copies....
  //
  //
  //
  //=======================================================
  void LoadImage(ip_Image<uchar> & MyImage,char fullname[],
		 ip_ImageType Timage,int debug)
  {
    chaine  nom(fullname),suf;
    int li,co;
    
    printf("Loading image   %s \n",fullname); fflush(stdout);
    //----------
    if(Timage==ip_NoImageType){
      Timage=ImType(suffixe_ch(fullname));
    }
    
    //----------

    switch(Timage){
    case ip_PGM:    case ip_RAW:
    case ip_PNM:    case ip_PPM:
    {
      Tab<octet> I;
      if(Timage==ip_PGM)      charge_pgm(I,fullname);
      else if(Timage==ip_PNM ||  Timage==ip_PPM)  charge_pnm(I,fullname,debug);
      else charge_raw(I,fullname,MyImage.nbLines(),MyImage.nbColumns());
      MyImage.allocateMem(I.dim1,I.dim2);
      for(li=0;li<I.dim1;li++){
	MyImage.setLine(li);
	for(co=0;co<I.dim2;co++)
	  MyImage.valueCol(co)=I(li,co);
      }
    }
    break;
    
  case ip_BMP: 
    {
      ipcv_Image<ip_ColorElement8u> I;
      cvReleaseImageHeader(&I.m_pImage);
      I.m_pImage=cvvLoadImage(fullname);
      I.refresh();
      MyImage.allocateMem(I.nbLines(),I.nbColumns());
      for(li=0;li<I.nbLines();li++){
	MyImage.setLine(li);
	for(co=0;co<I.nbColumns();co++) // bmp stores in b g r order
	  RGBToGray(I(li,co).b,I(li,co).g,I(li,co).r,MyImage.valueCol(co));
      }
    }
    break;
    

  default:
    printf("Unknown type for Load Image\n");
    fflush(stdout);
    break;
    
  }
  }

  //=======================================================
  void LoadImage(ip_Image<ip_ColorElement8u> & MyImage,char fullname[],
		 ip_ImageType Timage,int debug)
  {
    chaine  nom(fullname),suf;
    int li,co;
    
    printf("Loading image   %s \n",fullname); fflush(stdout);
    //----------
    if(Timage==ip_NoImageType){
      Timage=ImType(suffixe_ch(fullname));
    }
    
    //----------

    switch(Timage){
    case ip_PGM:    case ip_RAW:
    {
      Tab<octet> I;
      if(Timage==ip_PGM)      charge_pgm(I,fullname);
      else charge_raw(I,fullname,MyImage.nbLines(),MyImage.nbColumns());
      MyImage.allocateMem(I.dim1,I.dim2);
      for(li=0;li<I.dim1;li++){
	MyImage.setLine(li);
	for(co=0;co<I.dim2;co++)
	  MyImage.valueCol(co)=I(li,co);
      }
    }
    break;
    
    case ip_PNM:    case ip_PPM:
    {
      Tab<ip_ColorElement8u> I;
      charge_pnm(I,fullname);
      MyImage.allocateMem(I.dim1,I.dim2);
      for(li=0;li<I.dim1;li++){
	MyImage.setLine(li);
	for(co=0;co<I.dim2;co++)
	  MyImage.valueCol(co)=I(li,co);
      }
    }
    break;
    
  case ip_BMP: 
    {
      ipcv_Image<ip_ColorElement8u> I;
      cvReleaseImageHeader(&I.m_pImage);
      I.m_pImage=cvvLoadImage(fullname);
      I.refresh();
      MyImage.allocateMem(I.nbLines(),I.nbColumns());
      for(li=0;li<I.nbLines();li++){
	MyImage.setLine(li);
	for(co=0;co<I.nbColumns();co++){ // bmp stores in b g r order
	  MyImage.valueCol(co).b=I(li,co).r;
	  MyImage.valueCol(co).g=I(li,co).g;
	  MyImage.valueCol(co).r=I(li,co).b;
	}
      }
    }
    break;
    

  default:
    printf("Unknown type for Load Image\n");
    fflush(stdout);
    break;
    
  }
  }

  //=======================================================
  //
  //
  //
  //=======================================================
  void SaveImage(ip_Image<uchar> & MyImage,char fullname[],
		 ip_ImageType Timage,int debug)
  {
    chaine  nom(fullname),suf;
    int li,co;
    
    printf("saving  image   %s \n",fullname); fflush(stdout);
    //----------
    if(Timage==ip_NoImageType){
      Timage=ImType(suffixe_ch(fullname));
    }
    
    //----------
    
    switch(Timage){
    case ip_PGM:     {
      Tab<octet> I;
      I.dimensionne(MyImage.nbLines(),MyImage.nbColumns());
      for(li=0;li<I.dim1;li++){
	MyImage.setLine(li);
	for(co=0;co<I.dim2;co++){
	  I(li,co)=MyImage.valueCol(co);
	}
      }
      chaine name=ImType(suffixe_ch(fullname))!=ip_PGM ? chaine(fullname)+".pgm" :  chaine(fullname); 
      sauve_pgm(I,name.s);
    }
    break;

    case ip_RAW: {
      Tab<uchar> I;
      I.dimensionne(MyImage.nbLines(),MyImage.nbColumns());
      for(li=0;li<I.dim1;li++){
	MyImage.setLine(li);
	for(co=0;co<I.dim2;co++)
	  I(li,co)=MyImage.valueCol(co);
      }
      sauve_raw(I,fullname);
    }
    break;
    
    case ip_PNM:    case ip_PPM:
    {
      Tab<ip_ColorElement8u> I;
      I.dimensionne(MyImage.nbLines(),MyImage.nbColumns());
      for(li=0;li<I.dim1;li++){
	MyImage.setLine(li);
	for(co=0;co<I.dim2;co++)
	  I(li,co)=MyImage.valueCol(co);
      }
      chaine name;
      if(Timage==ip_PPM){
	if(ImType(suffixe_ch(fullname))!=ip_PPM)
	  name=chaine(fullname)+".ppm";
	else name=chaine(fullname); 
	sauve_ppm(I,name.s);
      }
      else {
	if(ImType(suffixe_ch(fullname))!=ip_PNM)
	  name=chaine(fullname)+".pnm";
	else name=chaine(fullname); 
	sauve_pnm(I,name.s);
      }
    }
    break;
    
    case ip_BMP: 
      {
	ipcv_Image<ip_ColorElement8u> I(MyImage.nbLines(),MyImage.nbColumns());
	for(li=0;li<I.nbLines();li++){
	  MyImage.setLine(li);
	  I.setLine(li);
	  for(co=0;co<I.nbColumns();co++){ // bmp stores in b g r order
	    I(li,co)=MyImage.valueCol(co);
	  }
	}
	chaine name=ImType(suffixe_ch(fullname))!=ip_BMP ? chaine(fullname)+".bmp" :chaine(fullname);	
	cvvSaveImage(name.s,I.m_pImage);
      }
      break;
      

    default:
      printf("Unknown type for Saving Image\n");
      fflush(stdout);
      break;
      
    }
  }
  
  //=======================================================
  void SaveImage(ip_Image<ip_ColorElement8u> & MyImage,char fullname[],
		 ip_ImageType Timage,int debug)
  {
    chaine  nom(fullname),suf;
    int li,co;
    
    printf("Saving image   %s \n",fullname); fflush(stdout);
    //----------
    if(Timage==ip_NoImageType){
      Timage=ImType(suffixe_ch(fullname));
    }
    
    //----------

    switch(Timage){
    case ip_PGM:     {
      Tab<octet> I;
      I.dimensionne(MyImage.nbLines(),MyImage.nbColumns());
      for(li=0;li<I.dim1;li++){
	MyImage.setLine(li);
	for(co=0;co<I.dim2;co++){
	  RGBToGray(MyImage.valueCol(co).r,MyImage.valueCol(co).g,
		    MyImage.valueCol(co).b,I(li,co));
	}
      }
      chaine name=ImType(suffixe_ch(fullname))!=ip_PGM ? chaine(fullname)+".pgm" :  chaine(fullname); 
      sauve_pgm(I,name.s);
    }
    break;

    case ip_RAW: {
      Tab<ip_ColorElement8u> I;
      I.dimensionne(MyImage.nbLines(),MyImage.nbColumns());
      for(li=0;li<I.dim1;li++){
	MyImage.setLine(li);
	for(co=0;co<I.dim2;co++)
	  I(li,co)=MyImage.valueCol(co);
      }
      sauve_raw(I,fullname);
    }
    break;
    
    case ip_PNM:    case ip_PPM:
    {
      Tab<ip_ColorElement8u> I;
      I.dimensionne(MyImage.nbLines(),MyImage.nbColumns());
      for(li=0;li<I.dim1;li++){
	MyImage.setLine(li);
	for(co=0;co<I.dim2;co++)
	  I(li,co)=MyImage.valueCol(co);
      }
      chaine name;
      if(Timage==ip_PPM){
	if(ImType(suffixe_ch(nom))!=ip_PPM)
	  name=chaine(fullname)+".ppm";
	else name=chaine(fullname); 
	sauve_ppm(I,name.s);
      }
      else {
	/*if(ImType(suffixe_ch(nom))!=ip_PNM)
	  name=chaine(fullname)+".pnm";
	  else name=chaine(fullname); */
	//printf("nom = %s \n",nom.s);
	//sauve_pnm(I,name.s);
	sauve_pnm(I,nom.s);
      }
    }
    break;
    
    case ip_BMP: 
      {
	ipcv_Image<ip_ColorElement8u> I(MyImage.nbLines(),MyImage.nbColumns());
	for(li=0;li<I.nbLines();li++){
	  MyImage.setLine(li);
	  I.setLine(li);
	  for(co=0;co<I.nbColumns();co++){ // bmp stores in b g r order
	    I(li,co).r=MyImage.valueCol(co).b;
	    I(li,co).g=MyImage.valueCol(co).g;
	    I(li,co).b=MyImage.valueCol(co).r;
	  }
	}
	chaine name=ImType(suffixe_ch(fullname))!=ip_BMP ? chaine(fullname)+".bmp" :chaine(fullname);	
	cvvSaveImage(name.s,I.m_pImage);
      }
      break;
      

    default:
      printf("Unknown type for Saving Image\n");
      fflush(stdout);
      break;
      
    }
  }
  



}
