#ifndef IP_LINE_SEGMENT_INC
#define IP_LINE_SEGMENT_INC

#include "general.h"
#include "ip_PixelAndPoint.h"


namespace ImageProcessing {

//-----

/** Provides interface for a line segment: starting and end point, and slope.
    It also stores the detected features in contour processing

    @author Jean-Marc Odobez (Jean-Marc.Odobez@idiap.ch)
    @author Daniel Gatica-Perez (gatica@idiap.ch)
*/



  class ip_LineSegment
  {
    public:
      
    //members

    ip_Point  m_StartPoint; 
    ip_Point  m_EndPoint; 
    ip_Point  m_Normal;              //unit normal vector 
    real      m_dLength;
    int       m_iNumberOfPoints;
    ip_Point *m_pFeatures;           //pointer to the detected features
    int       m_iNumberOfFeatures;   //number of detected features

    //member functions 

    //-----
    ip_LineSegment();

    //-----
    ip_LineSegment(real xStart, real yStart, real xEnd,
		   real yEnd, int numberOfPoints);

    //-----
    ip_LineSegment(real xStart, real yStart, real xNormal, real yNormal,
		   real length, int numberOfPoints);

    //-----
    ip_LineSegment(ip_Point *pCentroid, ip_Point *pNormal,
		   real length, int numberOfPoints);

    //-----
    virtual void init(real xStart, real yStart, real xEnd,
		      real yEnd, int numberOfPoints);

    //-----
    virtual void init(real xCentroid, real yCentroid, real xNormal,
		      real yNormal, real length, int numberOfPoints);

    //-----
    virtual void init(ip_Point *pCentroid, ip_Point *pNormal,
		      real length, int numberOfPoints);

    //-----
    virtual void init(ip_Point *pCentroid, ip_Point *pNormal,
		      real length, int numberOfPoints, int rows, int cols);

    //----
    virtual void freeMemory(void);

    //-----
    virtual ~ip_LineSegment()
    {freeMemory();}

  };


}

#endif // IP_LINE_SEGMENT_INC
