#ifndef IP_IMAGENAME_INC
#define IP_IMAGENAME_INC

//#include "general.h"
#include "StringClass.h"
#include "ip_LoadSaveImage.h"

namespace ImageProcessing {

  //-----
  
  /** 
   
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  //===================================================
  //
  //
  //===================================================

  typedef enum { Standart=1, FixedLength=2 } TypeNumberOutput;

  class ip_ImageName {
  public:
    chaine            m_cDirectory;
    chaine            m_cBaseName;
    chaine            m_cExtension;
    int               m_iNumber;
    ip_ImageType      m_tType;
    int               m_iTypeNumber; // type of way for outputing numbers
    int               m_iNbDigits;     // total number of digits that should appear
    // in image name (e.g. number is 40, we need 5 digits --> number(string) = 00040)

    chaine            m_cFullName;

    //-----------
    ip_ImageName(int _TypeNumber=Standart,int _NbDigits=5);

    //-----------
    ip_ImageName(char * OneName,int _TypeNumber=Standart,int _NbDigits=-1);

    //-----------
    ip_ImageName(chaine &dir, chaine &base, chaine & ext,int number,
		 ip_ImageType type,int _TypeNumber=Standart,int _NbDigits=5);

    //-----------
    char * fullName();
    
    //-----------
    chaine number(); // needed if we want to modify the way number is outputed

    //-----------
    void display(FILE *f=stdout);

    //-----------
    ~ip_ImageName();


  };



   
}

#endif
