#ifndef IP_IMAGE_FEATURE_FUNCTIONS_INC
#define IP_IMAGE_FEATURE_FUNCTIONS_INC

#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <iomanip.h>

#include "general.h"
#include "ip_Image.h"
#include "ip_ColorDef.h"
#include "ip_PixelAndPoint.h"
#include "ip_LineSegment.h"
#include "ip_Ellipse.h"

namespace ImageProcessing {

//-----

/** Miscellaneous functions to compute 1-D image features

    @author Jean-Marc Odobez (Jean-Marc.Odobez@idiap.ch)
    @author Daniel Gatica-Perez (gatica@idiap.ch)

*/


/***************************************************
 parameters for canny operator
***************************************************/	 
#define SIGMA_FILTER_EDGE_DETECTION 1
#define EDGE_THRESHOLD              10.0  
#define IP_EDGE_PIXEL               1.0
#define IP_NON_EDGE_PIXEL           0.0


/***************************************************
 parameters for rgb2y conversion: on the fly or precomputed 
 for entire image
***************************************************/	
#define ON_LINE_RGB2Y        0
#define PRE_COMPUTED_RGB2Y   1
#define OPTION_PREPROCESSING ON_LINE_RGB2Y
 

  class ip_1D_Vector
  {
   public:

    //members

    real *m_pData;
    int m_iSize;

    //member functions

    ip_1D_Vector()
    {m_pData = NULL;}

    ip_1D_Vector(int size)
    {create(size);}

    void create(int size)
    {m_iSize=size; m_pData=new real[size];}

    void put(int x, real value)
    {if(x>=0 && x<m_iSize) m_pData[x]=value;}

    real get(int x)
    {if(x>=0 && x<m_iSize) return m_pData[x]; 
     else if(x>m_iSize) return m_pData[m_iSize-1]; else return m_pData[0];}
    
    void freeMemory(void)
    {if(m_pData!=NULL) delete[] m_pData; m_pData = NULL;}

    void display(void)
    {for(int i=0;i<m_iSize;i++) printf("%f ", m_pData[i]); printf("\n");}

    ~ip_1D_Vector()
    {freeMemory();}

  };



  //-------
  int ip_Round(float x);

  //-------
  real ip_rgb2y(int x, int y, ip_Image<ip_ColorElement8u> &Image);

  //-------
  real ip_rgb2y(int x, int y, ip_Image<ip_ColorElement8u> *pImage);

  //-------
  real ip_dataAt(int x, int y, int band, ip_Image<ip_ColorElement8u> *pImage);

  //-------
  real ip_bilinearInterpolation(ip_Point *pPoint, 
				ip_Image<ip_ColorElement8u> &Image);

  //-------
  real ip_bilinearInterpolation(ip_Point *pPoint, 
				ip_Image<ip_ColorElement8u> *pImage);

  //-------
  real ip_bilinearInterpolation(ip_Point *pPoint, 
				unsigned char *pImage, int cols);

  //-------
  void ip_generateLineOfMeasurements(ip_LineSegment *pLine, 
				     ip_Image<ip_ColorElement8u> &Image, 
				     ip_1D_Vector *pData);

  //-------
  void ip_generateLineOfMeasurements(ip_LineSegment *pLine, 
				     ip_Image<ip_ColorElement8u> *pImage, 
				     ip_1D_Vector *pData);

  //-------
  void ip_generateLineOfMeasurements(ip_LineSegment *pLine,
				     unsigned char *pImage, int cols,
				     ip_1D_Vector *pData);

  //-------
  void ip_Create1DGaussianFilter(ip_1D_Vector *pFilter, int sigma);

  //-------
  void ip_Convolve1DGaussianFilter(ip_1D_Vector *pSignalIn, 
				   ip_1D_Vector *pFilter,
				   ip_1D_Vector *pSignalOut);

  //-------
  void ip_1DGradient(ip_1D_Vector *pSignalIn, ip_1D_Vector *pSignalOut);

  //-------
  void ip_1DThreshold(ip_1D_Vector *pSignalIn, ip_1D_Vector *pSignalOut,
		      float threshold);

  //-------
  void ip_1DNonMaximumSupression(ip_1D_Vector *pSignalGrad, 
				 ip_1D_Vector *pSignalEdges, 
				 ip_1D_Vector *pSignalOut);

  //-------
  void ip_1DNonMaximumSupression(ip_1D_Vector *pSignalGrad, 
				 ip_1D_Vector *pSignalEdges, 
				 ip_LineSegment *pLine);

  //-------
  void ip_1DEdgeDetection(ip_1D_Vector *pSignalIn,  
			  ip_1D_Vector *pSignalOut, 
			  real sigma, real threshold);

  //-------
  void ip_1DEdgeDetection(ip_1D_Vector *pSignalIn,  
			  ip_LineSegment *pLine, 
			  real sigma, real threshold);

  //-------
  void ip_ComputeEdgeFeatures(ip_LineSegment *pLine, 
			      ip_Image<ip_ColorElement8u> &Image, 
			      ip_1D_Vector *pSignalIn, 
			      ip_1D_Vector *pSignalOut,
			      int sigma, real threshold);

  //-------
  void ip_ComputeEdgeFeatures(ip_LineSegment *pLine, 
			      ip_Image<ip_ColorElement8u> *pImage, 
			      ip_1D_Vector *pSignalIn, 
			      ip_1D_Vector *pSignalOut,
			      int sigma, real threshold);

  //-------
  void ip_ComputeEdgeFeatures(ip_LineSegment *pLine, 
			      ip_Image<ip_ColorElement8u> *pImage, 
			      ip_1D_Vector *pSignalIn,
			      int sigma, real threshold);

  //-------
  void ip_ComputeEdgeFeatures(ip_LineSegment *pLine, 
			      unsigned char *pImage, int cols,
			      ip_1D_Vector *pSignalIn,
			      int sigma, real threshold);
  //-------
  void ip_DrawDetectedPoints(ip_LineSegment *pLine, ip_1D_Vector *pSignal,
			     ip_Image<ip_ColorElement8u> &Image, 
			     ip_ColorElement8u color);

  //-------
  void ip_DrawDetectedPoints(ip_LineSegment *pLine, ip_1D_Vector *pSignal,
			     ip_Image<ip_ColorElement8u> *pImage, 
			     ip_ColorElement8u color);
  //-------
  void ip_DrawDetectedPoints(ip_LineSegment *pLine, 			   
			     ip_Image<ip_ColorElement8u> *pImage, 
			     ip_ColorElement8u color);

}

#endif // IP_IMAGE_FEATURE_FUNCTIONS_INC
