#ifndef IP_DRAW_FUNCTIONS_INC
#define IP_DRAW_FUNCTIONS_INC


#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <iomanip.h>

#include "general.h"
#include "ip_Image.h"
#include "ip_ColorDef.h"
#include "ip_PixelAndPoint.h"


namespace ImageProcessing {

//-----

/** Variety functions to draw stuff on an image 

    @author Jean-Marc Odobez (Jean-Marc.Odobez@idiap.ch)
    @author Daniel Gatica-Perez (gatica@idiap.ch)

*/

  //-------
  int ip_sign(int datum);

  //-------
  real ip_euclideanDistance(ip_Point p1, ip_Point p2);

  //-------
  void ip_unitaryDifferenceVector(ip_Point *p1, ip_Point *p2, ip_Point *pOut);

  //-------
  bool ip_inImage(ip_Point p, int rows, int cols);

  //-------
  bool ip_inImage(ip_Point *p, int rows, int cols);

  //-------
  real ip_angle(ip_Point p1, ip_Point p2);

  //-------
  void ip_extremePoint(ip_Point *pP1,ip_Point *pP2,ip_Point *pPOut,
		       int rows,int cols);

  //-------
  void ip_safeDraw(ip_Point *pP1, ip_Point *pP2, 
		   ip_Image<ip_ColorElement8u> *pImage, 
		   ip_ColorElement8u color);

  //-------
  void ip_drawClosedListOfPoints(int NumberOfPoints, ip_Point *pPointList, 
				 ip_Image<ip_ColorElement8u> &Image, 
				 ip_ColorElement8u color);

  //-------
  void ip_drawClosedListOfPoints(int NumberOfPoints, ip_Point *pPointList, 
				 ip_Image<ip_ColorElement8u> *pImage, 
				 ip_ColorElement8u color);

  //-------
  void ip_drawOpenListOfPoints(int NumberOfPoints, ip_Point *pPointList, 
			       ip_Image<ip_ColorElement8u> &Image, 
			       ip_ColorElement8u color);

  //-------
  void ip_drawOpenListOfPoints(int NumberOfPoints, ip_Point *pPointList, 
			       ip_Image<ip_ColorElement8u> *pImage, 
			       ip_ColorElement8u color);

  //-------
  void ip_drawOpenListOfPoints(int NumberOfPoints,
			       int *pValidPoint,
			       ip_Image<ip_ColorElement8u> *pImage, 
			       ip_ColorElement8u color);

  //-------
  void ip_bresenham(int x1, int y1, int x2, int y2, 
		    ip_Image<ip_ColorElement8u> &Image, 
		    ip_ColorElement8u color);

  //-------
  void ip_bresenham(int x1, int y1, int x2, int y2, 
		    ip_Image<ip_ColorElement8u> *pImage, 
		    ip_ColorElement8u color);

  //-------
  void ip_bresenham(ip_Point *pPoint1, ip_Point *pPoint2, 
		    ip_Image<ip_ColorElement8u> &Image, 
		    ip_ColorElement8u color);

  //-------
  void ip_bresenham(ip_Point *pPoint1, ip_Point *pPoint2, 
		    ip_Image<ip_ColorElement8u> *pImage, 
		    ip_ColorElement8u color);

}

#endif // IP_DRAW_FUNCTIONS_INC

