#ifndef IP_BASESEQIMAGE_INC
#define IP_BASESEQIMAGE_INC

#include "ip_Image.h"

namespace ImageProcessing {

  //-----
  
  /** 
  //===================================================
  // 
  //    Sequence representation
  //

  ---> Created classes :  

  template <class Type>
  ip_BaseSeqImage : basic class interface for 
                    reading interaces of sequences
  

    @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  //===================================================
  //
  //    class         ip_BaseSeqImage
  //
  //    Base virtual class for image sequence representation
  //
  //    The sequence holds N images of the specified type
  //    so that you can get the current one, and the previous
  //    ones.
  //    You can not perform any jump in this implementation
  //    
  //
  //    10-May-2002 : Initial setup
  //
  //===================================================

  //===================================================
  template <class Type>
    class  ip_BaseSeqImage {
    public:
    virtual ip_Image<Type> * currentImage()=0;
    virtual ip_Image<Type> * previousImage(int i)=0; // 0 = current, 1 -> t-1, 2 -> t-2...
    virtual bool             firstImage()=0;
    virtual bool             nextImage()=0;
   
    //  virtual ~ip_BaseSeqImage()=0;
    
  };

   
}

#endif
