// ************************************************************************************
// String Class
//
// version 
// *************************************************************************************






#ifndef STRING_CLASS_HH
#define STRING_CLASS_HH

#include <string.h>				// for strcat(), strcmp() etc...
#include <stdio.h>				// for sprintf()
#include <stdlib.h>				// for  atoi()





// DECLARATION of the string class	// ALL inline...
// ***************************************************************************

class chaine
{
 public:
  char *s;					// chaine de caracteres (string)
  int  alloc;					// allocation (nbcar + 1)


// ----- CONSTRUCTION / DESTRUCTION ------------------------------------------

chaine(int n=256)				// constructeur (avec ou sans argument)
 {alloc = n+1;
  s     = new char [alloc];			// alloue taille + 0 terminal
  s[0]  = '\0';					// met en place le 0 terminal
 }

chaine(char *s2)				// constructeur (a partir de string)
 {alloc  = strlen(s2)+1;
 s      = new char [alloc];			// alloue taille + 0 terminal
 strcpy(s,(const char *)s2);
 }

chaine(const char *s2)				// constructeur (a partir de string)
 {alloc  = strlen(s2)+1;
  s      = new char [alloc];			// alloue taille + 0 terminal
  strcpy(s,s2);
 }

chaine(int i, char* m)				// constructeur (i fois motif m)
 {alloc  = i*strlen(m)+1;
  s      = new char [alloc];			// alloue taille + 0 terminal
  s[0]  = '\0';					// met en place le 0 terminal

  for(int k=0; k<i;  k++)
	strcat(s,m);
 }

chaine(const chaine& c2)			// constructeur par recopie
 {alloc  = strlen(c2.s)+1;
  s      = new char [alloc];			// alloue taille + 0 terminal
  strcpy(s,c2.s);
 }

~chaine()					// destructeur
 {delete [] s;}




// ----- OPERATEURS -----------------------------------------------------------

char operator[](int i)	 const			// chaine[i] const : non-affectable
 { return s[i]; }

char& operator[](int i)				// chaine[i] : affectable
 { return s[i]; }

chaine& operator=(const chaine& c2)
{
 if(this != &c2)
    {delete [] s;

    alloc  = strlen(c2.s)+1;
    s      = new char [alloc];			// alloue taille + 0 terminal
    strcpy(s, c2.s);
    }
 return *this;
}

operator char*() const		{return s;}	// cast chaine (const) -> string
//operator char*()		{return s;}	// cast chaine -> string (idem)

// ---------------------------------------------------------------------------
inline friend	int 	operator==(const chaine& c1, const chaine& c2);
inline friend	int 	operator!=(const chaine& c1, const chaine& c2);
inline friend	chaine	operator+(const chaine& c1, const chaine& c2);
inline friend	chaine	operator+(const chaine& c1, int i);
inline friend	chaine	operator+(const chaine& c1, double d);
inline friend	chaine	operator-(const chaine& c1, const chaine& c2);

inline friend	int	longueur_ch(const chaine& c);
inline friend	int	valeur_ch(const chaine& c);
inline friend	chaine	suffixe_ch(const chaine& c);            // .term = suffixe
inline friend	chaine	debut_ch(const chaine& c, int n);	// les n 1ers car.
inline friend 	chaine	fin_ch(const chaine& c, int n);		// les n derniers car.
inline friend 	chaine	milieu_ch(const chaine& c,int i,int j);	// les car. de i  j
inline friend	chaine	reste_ch(const chaine& c,int i);	// du car. i  la fin


};


// ---- FONCTIONS AMIES DE LA CLASSE chaine ----------------------------------
// ***************************************************************************

inline int    operator==(const chaine& c1, const chaine& c2)
 { return( strcmp(c1.s,c2.s)==0 ); }

inline int    operator!=(const chaine& c1, const chaine& c2)
 { return !(c1==c2); }


// ---------------------------------------------------------------------------
inline chaine  operator+(const chaine& c1, const chaine& c2)
 {chaine res(strlen(c1.s)+strlen(c2.s)+1);	// taille + 0 terminal

  strcpy(res.s,c1.s);				// res = c1
  strcat(res.s,c2.s);				// res = res + c2
  return(res);
 }

inline chaine  operator+(const chaine& c1, int i)
 {chaine c2;
  sprintf(c2.s,"%d",i);

  return(c1+c2);
 }

inline chaine  operator+(const chaine& c1, double d)
 {chaine c2;
  sprintf(c2.s,"%f",d);

  return(c1+c2);
 }

// ---------------------------------------------------------------------------
inline chaine  operator-(const chaine& c1, const chaine& c2)
 {chaine res = c1;				// res = c1

  int	i  = strlen(res.s)-1;			// indice du dernier caractre
  int	i2 = strlen(c2.s)-1;			// ..

  while( i>=0 && i2>=0 && res.s[i]==c2.s[i2])
	{res.s[i]='\0'; i--; i2--;}
  return(res);					// la recopie liminera les \0 inutiles
 }


// ---------------------------------------------------------------------------
inline int longueur_ch(const chaine& c)
 { return strlen(c.s); }


// ---------------------------------------------------------------------------
inline int valeur_ch(const chaine& c)
 { return atoi(c.s); }


// ---------------------------------------------------------------------------
inline chaine suffixe_ch(const chaine& c)
 {
  for(int i=strlen(c.s)-1;  i>=0;  i--)		// boucle du dernier au 1er caractre
   {if( c.s[i]=='.' )			return chaine( c.s+i );
    if( c.s[i]=='/' || c.s[i]=='\\' )	return chaine("");
   }
  return chaine("");
 }


// ---------------------------------------------------------------------------
inline chaine debut_ch(const chaine& c, int n)	// les n 1ers caractres
 {chaine res(n);

  strncpy(res.s, c.s, n);  res.s[n]='\0';	// copie + met le 0 terminal non-copi
  return(res);
 }

// ---------------------------------------------------------------------------
inline chaine milieu_ch
               (const chaine& c,int i,int j)	// les caractres du rang i  j
 {int 	   n   = j-i+1;				// longueur du resultat
  chaine   res(n);
  char	   *p  = &(c.s[i]);			// pointeur sur le debut  copier

  strncpy(res.s, p, n);  res.s[n]='\0';		// copie + met le 0 terminal non-copi
  return(res);
 }


// ---------------------------------------------------------------------------
inline chaine fin_ch(const chaine& c, int n)	// les n derniers caractres
 { if( (int)(strlen(c.s)) <= n)	return c;
   else				return chaine( c.s+strlen(c.s)-n );
 }


// ---------------------------------------------------------------------------
inline chaine reste_ch(const chaine& c,int i)	// caractres du rang i  la fin
 { if( i >= (int)strlen(c.s) )	return chaine("");
   return 			chaine( c.s+i  );
 }


// ***************************************************************************

#endif // STRING_CLASS_HH
