// **************************************************************************
// Pixel and Points class 
//
// Description :  
//           Contains the definition of the Pixel class and Point class
//           Pixel manipulate essentially integer coordinates, whereas
//           Points coordinates are defined with doubles
//
// version 
// *************************************************************************************






#ifndef PIXEL_POINT_CLASS_HH
#define PIXEL_POINT_CLASS_HH

#include "macros.h"
#include <math.h>				// for sqrt()
#include <iostream.h>
#include <iomanip.h>


// DECLARATION of PIXEL CLASS   	// ALL    inline...
// ***************************************************************************
#define   vecteur_pixel	pixel		       // Only for notations clarity
#define	PIXEL_NIL	pixel(-1,-1)
#define	VECTEUR_PIXEL_NIL	pixel(-1,-1)


class pixel
{
 public:
  int L,C;			     // image coordinates : line/column

pixel(int vC=0, int vL=0)		     // constructor (with or without  argument)
 { L=vL; C=vC; }			     // Rem: we first give 'x', i.e. the column
                                             // number, then 'y', the line number

// ---------------------------------------------------------------------------
inline pixel&	operator+=(vecteur_pixel v)
 { L+=v.L; C+=v.C;   return *this; }
inline pixel&	operator-=(vecteur_pixel v)
 { L-=v.L; C-=v.C;   return *this; }

// ---------------------------------------------------------------------------
  void affiche(char * com)
  { cout<<com<<"("<<setw(5)<<L<<","<<setw(5)<<C<<") "; }

  void affiche(char * com) const
  { cout<<com<<"("<<setw(5)<<L<<","<<setw(5)<<C<<") "; }
// ---------------------------------------------------------------------------
inline  	pixel  operator-()
  { return ( pixel(-C,-L)); }
inline  	pixel  operator-() const
  { return ( pixel(-C,-L)); }

  inline friend	int    operator==(pixel p1, pixel p2);
  inline friend	int    operator!=(pixel p1, pixel p2);
  inline friend	pixel  operator+(pixel p, vecteur_pixel v);
  inline friend 	pixel  operator-(pixel p, vecteur_pixel v);
  
  // scalar product
  inline friend 	double operator*(vecteur_pixel v1, vecteur_pixel v2); 
  // external product 
  inline friend 	vecteur_pixel operator*(int k, vecteur_pixel v);	

  inline friend	double norme(vecteur_pixel v);
  inline friend	double distance(pixel p1, pixel p2);
  
  inline   friend double  OrientationDroiteDeg(pixel p1,pixel p2);
  
  inline friend ostream & operator<<(ostream & sortie, pixel & pi);
  
  inline friend ostream & operator<<(ostream & sortie, const pixel & pi);

};


// FONCTIONS AMIES DE LA CLASSE pixel
// ***************************************************************************

inline int operator==(pixel p1, pixel p2)
{ return( p1.C==p2.C && p1.L==p2.L ); }

inline int operator!=(pixel p1, pixel p2)
{ return !(p1==p2); }

inline pixel operator+(pixel p, vecteur_pixel v)
{return( pixel( p.C+v.C, p.L+v.L) ); }

inline pixel operator-(pixel p, vecteur_pixel v)
{return( pixel( p.C-v.C, p.L-v.L) ); }

inline double operator*(vecteur_pixel v1, vecteur_pixel v2)
{return( v1.C*v2.C + v1.L*v2.L ); }

inline vecteur_pixel operator*(int k, vecteur_pixel v)
{return vecteur_pixel(k*v.C,k*v.L); }

inline double norme(vecteur_pixel v)
{ return( sqrt( (double)(v.L*v.L + v.C*v.C) ) ); }

inline double angle(vecteur_pixel v)
{    return (180.+atan2((double)(v.L),(double)(v.C))*180./PI);
}

// ATTENTION : ANGLE AND ANGLERAD RETURN OPPOSITE ANGLES
inline double anglerad(vecteur_pixel v)
{    return (atan2((double)(v.L),(double)(v.C)));
}

inline double distance(pixel p1, pixel p2)
{ return( norme(p2-p1) ); }

inline   double  OrientationDroiteDeg(pixel p1,pixel p2)
{ double angle=atan2((double)(p2.L-p1.L),(double)(p2.C-p1.C))*180./PI;
 if(angle<0)
   return (angle+180.);
 else return angle;
}

inline ostream & operator<<(ostream & sortie, pixel & pi)
{
  sortie<<"("<<setw(5)<<pi.L<<","<<setw(5)<<pi.C<<") ";
  return sortie;
}
inline ostream & operator<<(ostream & sortie, const pixel & pi)
{
  sortie<<"("<<setw(5)<<pi.L<<","<<setw(5)<<pi.C<<") ";
  return sortie;
}


// ***************************************************************************






// DECLARATION of the class POINT    
//
// ALMOST THE SAME MEMBERS FUNCTIONS AND OPERATORS THAN PIXEL, BUT FOR POINTS
//
// ALL inline ...
// ***************************************************************************
#define vecteur		point	    // Only for notations clarity
#define	VECTEUR_NIL     vecteur(0,0)
#define	POINT_NIL       point(0,0)

class point
{
 public:
  double x,y;				  // coordinates

  point(double vx=0, double vy=0)		  // constructor (with or without argument)
  { x=vx; y=vy; }

  point(int vx, int vy)	                      // constructor
  { x=(double)vx; y=(double)vy; }

  point(pixel p)
  { x=(double)p.C;				  // pixel : integer coordinates
  y=(double)p.L;
  }

  // ---------------------------------------------------------------------------
  inline point&	operator+=(vecteur v)
  { x+=v.x; y+=v.y;   return *this; }
  inline point&	operator-=(vecteur v)
  { x-=v.x; y-=v.y;   return *this; }
  
  // ---------------------------------------------------------------------------
  void affiche(char * com)
  { cout<<com<<"("<<setw(5)<<y<<","<<setw(5)<<x<<") "; }
  
  void affiche(char * com) const
  { cout<<com<<"("<<setw(5)<<y<<","<<setw(5)<<x<<") "; }
  // ---------------------------------------------------------------------------
  inline 	point  operator-()
  { return (point(-x,-y)); }
  inline 	point  operator-()  const
  { return (point(-x,-y)); }


  inline friend 	point  operator+(point p, vecteur v);
  inline friend 	point  operator-(point p, vecteur v);
  inline friend 	double operator*(vecteur v1, vecteur v2);    // scalar product
  inline friend 	vecteur operator*(double k, vecteur v);	     // external product
  
  inline double   p_vectoriel(vecteur v1, vecteur v2);	// val(vectorial product)
  inline friend	double norme(vecteur v);
  inline friend	double distance(point p1, point p2);
  
  inline friend   vecteur VunitaireDeg(double thet);
  inline friend   vecteur Vunitaire(double thet); // thet expressed in radian
  inline friend   vecteur Vunitaire(pixel p1,pixel p2);
  inline friend   vecteur Vunitaire(vecteur_pixel vp);
  inline friend   vecteur Vunitaire(point p1,point p2);
  inline friend   vecteur Vunitaire(vecteur vp);

  inline friend   point   ptarrondi(point p1);
  inline friend   pixel   pixarrondi(point p1);

  inline friend   double  OrientationDroiteDeg(point p1,point p2);

};


// FRIENDS FONCTIONS of point class

inline point operator+(point p, vecteur v)
{return( point( p.x+v.x, p.y+v.y) ); }

inline point operator-(point p, vecteur v)
{return( point( p.x-v.x, p.y-v.y) ); }

inline double operator*(vecteur v1, vecteur v2)
{return( v1.x*v2.x + v1.y*v2.y ); }

inline vecteur operator*(double k, vecteur v)
{return vecteur(k*v.x , k*v.y); }

inline double p_vectoriel(vecteur v1, vecteur v2)	   // val(produit_vectoriel)
{return(v1.x*v2.y - v1.y*v2.x); }		   // i.e. determinant

inline double norme(vecteur v)
{return( sqrt(v.x*v.x + v.y*v.y) ); }

inline double distance(point p1, point p2)
 {return( norme(p2-p1) ); }

inline    vecteur VunitaireDeg(double thet)
{ return vecteur(cos(thet*PI/180.),sin(thet*PI/180.)); }

inline    vecteur Vunitaire(double thet) // en radian 
{ return vecteur(cos(thet),sin(thet)); }



inline   vecteur Vunitaire(vecteur_pixel vp)
{  double N=norme(vp);
 if(N<0.001)
   return vecteur(0.,0.0);
 else
   return vecteur(vp.C/N,vp.L/N);
}

inline    vecteur Vunitaire(pixel p1,pixel p2)
{   return Vunitaire(p2-p1);
}

inline   vecteur Vunitaire(vecteur vp)
{  double N=norme(vp);
 if(N<0.00001)
   return vecteur(0.,0.0);
 else
   return vecteur(vp.x/N,vp.y/N);
}

inline    vecteur Vunitaire(point p1,point p2)
{   return Vunitaire(p2-p1);
}




inline double angle(vecteur v)
{    return (180.+atan2((double)(v.y),(double)(v.x))*180./PI);
}


inline    point   ptarrondi(point p1)
{ return point((double)(MyArrondi(p1.x)),(double)(MyArrondi(p1.y))); }

inline    pixel   pixarrondi(point p1)
{ return pixel((MyArrondi(p1.x)),(MyArrondi(p1.y))); }

inline   double  OrientationDroiteDeg(point p1,point p2)
{ double angle=atan2((p2.y-p1.y),(p2.x-p1.x))*180./PI;
  if(angle<0)
    return (angle+180.);
  else return angle;
}

// ***************************************************************************




#endif // PIXEL_POINT_CLASS_HH
