/* 
------------------------------------------------------------------------
_Institution : IDIAP
------------------------------------------------------------------------
_Module_Name : 

_Description : contains all template functions for loading and saving

_Call :        

_System  : Unix
_Remarks : None

_Author : Jean-Marc Odobez
_Revisions History:


------------------------------------------------------------------------
template <class Type>
void charge_raw(Tab<Type> & MonImage, char* nom, int ti, int tj) // ti,tj optionnels
				 			  // =DIM_INDEFINIE si absents

template <class Type>
void sauve_raw(Tab<Type> & MonImage, char* nom)


// P3 (ppm) and P6 (pnm) format (charge_ppm and charge_pnm are equivallent
void charge_ppm(Tab<ip_ColorElement8u> & MonImage, char* nom,int debug=0);

inline void charge_ppm(Tab<ip_ColorElement8u> & MonImage, char* nom,int debug=0);

// sauve_pnm and sauve_ppm are equivalent (except the default)
void sauve_pnm(Tab<ip_ColorElement8u> & MonImage,
	       char *nom,
	       int  P3=0, // defaut = pnm
	       int debug	   = 1,
	       //	 char *ext = "",
	       char *commentaire = "JMarc Odobez - Created by PNM-library",
	       char *commentaire2= "",
	       char *commentaire3= ""
	       );

inline void sauve_ppm(Tab<ip_ColorElement8u> & MonImage,
		      char *nom,
		      int  P3=1, // defaut = ppm
		      int debug	   = 1,
		      //	 char *ext = "",
		      char *commentaire = "JMarc Odobez - Created by PNM-library",
		      char *commentaire2= "",
		      char *commentaire3= ""
		      )



template <class Type>				// gnralis a tous le types
void charge_pgm(Tab<Type> & MonImage, char* nom,int debug=0)

template <class Type>				// gnralis a tous le types
void sauve_pgm(Tab<Type> & MonImage,
	       char *nom,
	       int debug	   = 1,
	       //	 char *ext = "",
	       char *commentaire = "JMarc Odobez - Created by PGM-library",
	       char *commentaire2= "",
	       char *commentaire3= ""
	       )


------------------------------------------------------------------------
_end
*/


#ifndef MyLoadSaveImageT_HH
#define MyLoadSaveImageT_HH




#include "tab.h"
#include "ip_ColorDef.h"
#include "try_fopen.h"

namespace ImageProcessing {

  // ***************************************************************************
  template <class Type>
    void charge_raw(Tab<Type> & MonImage, char* nom, int ti, int tj) // ti,tj optionnels
    // =DIM_INDEFINIE si absents
    {
      FILE* f = try_fopen(nom,"r");
#ifdef Msg_ES
      cout<<"Lecture de "<<nom<<" ..."<<endl;
#endif
      

      if( ti!=DIM_INDEFINIE || tj!=DIM_INDEFINIE )	// si dimensions transmises
	if( MonImage.dim1!=ti || MonImage.dim2!=tj )
	  {
	    MonImage.libere_partie_dyn();
	    MonImage.alloue_partie_dyn(0,ti-1,0,tj-1);
	  }
      

      fseek(f,0L,SEEK_END);				// va  la fin du fichier
      while( ftell(f) != MonImage.dim1*MonImage.dim2*(int)sizeof(Type) )
	{
	  MonImage.libere_partie_dyn();
	  cerr<<"  Pas de memoire allouee pour cette taille de fichier-image"<<endl;
	  cerr<<"  Entrez ses dimensions lignes,colonnes: " ;
	  cin>>MonImage.dim1>>MonImage.dim2;
	  MonImage.alloue_partie_dyn(0,MonImage.dim1-1,0,MonImage.dim2-1);
	}
      

      rewind(f);					// revient au debut et charge
      try_fread( (char*)&(MonImage.ptr2[MonImage.inf1][MonImage.inf2]),sizeof(Type),MonImage.dim1*MonImage.dim2,f,nom);
      fclose(f);
    }



  // ***************************************************************************
  template <class Type>
    void sauve_raw(Tab<Type> & MonImage, char* nom)
    {
      FILE* f = try_fopen(nom,"w");
#ifdef Msg_ES
      cout<<"Ecriture de "<<nom<<" ..."<<endl;
#endif
      
      try_fwrite( (char*)&(MonImage.ptr2[MonImage.inf1][MonImage.inf2]),sizeof(Type),
		  MonImage.dim1*MonImage.dim2,f,nom);
      
      fclose(f);
    }


  
  // ***************************************************************************
  template <class Type>				// gnralis a tous le types
    void charge_pgm(Tab<Type> & MonImage, char* nom,int debug=0)
    {
      FILE* f = try_fopen(nom,"r");
      int  ti,tj;
      int  size,good_size;
      char c, marque[2+1];				// 2 carac. + 0 terminal

      
      
      // LECTURE DE L'ENTETE PGM
      // =======================
      fscanf(f,"%2s\x0A%c", marque,&c);		// absorbe P5+'CR' et lit car. suivant
      if( marque[0]!='P' || marque[1]!='5')
	{cerr<<"Abandon: Pas d'entete PGM dans "<<nom<<endl;    exit(-1);}
      
      
      // ABSORBE LES n LIGNES DE COMMENTAIRE (CONSECUTIVES)
      // ==================================================
      while( c=='#' )
	{fscanf(f,"%*[^\x0A]\x0A%c",&c); 		// absorbe commentaire ($0A inclus)
	}
      fseek(f,-1L,SEEK_CUR);				// recule pour se remettre sur c
      
      
      // LECTURE DES INFOS IMAGE
      // =======================
      fscanf(f," %d %d",&tj,&ti);			// lecture des infos-image
      if( sizeof(Type)==1 )
	{good_size =255;
	fscanf(f," %d\x0A",&size);		// PGM normal (8 bits): niveau gris max
  	}
      else	{good_size = sizeof(Type);
      fscanf(f," %d bytes\x0A",&size);	// PGM generalis: taille des elements
      }
      if( size != good_size )
	{cerr<<"Abandon: elements de taille incorrecte dans "<<nom<<endl;
	exit(-1);
	}
      
#ifdef Msg_ES
      if(debug>0){
	cout<<"Lecture de "<<nom<<" ... ("<<ti<<" x "<<tj<<")"<<endl;
      }
#endif
      
      
      if( MonImage.dim1!=ti || MonImage.dim2!=tj )
	{
	  MonImage.libere_partie_dyn();
	  MonImage.alloue_partie_dyn(0,ti-1,0,tj-1);
	}
      
      
      // LECTURE DES PIXELS
      // ==================
      try_fread( (char*)&(MonImage.ptr2[MonImage.inf1][MonImage.inf2]),
		 sizeof(Type),MonImage.dim1*MonImage.dim2,f,nom);
      
      fclose(f);
    }
  
  
  // ***************************************************************************
  template <class Type>				// gnralis a tous le types
    void sauve_pgm(Tab<Type> & MonImage,
		   char *nom,
		   int debug	   = 1,
		   //	 char *ext = "",
		   char *commentaire = "JMarc Odobez - Created by PGM-library",
		   char *commentaire2= "",
		   char *commentaire3= ""
		   )
    {
      FILE* f;
      /*
	char nom_f[256];
	
	if(i==-1)	sprintf(nom_f,"%s",nom);	// parametres optionnels non fournis
	else		sprintf(nom_f,"%s%d%s",nom,i,ext);
      */
      
      f = try_fopen(nom,"w");
#ifdef Msg_ES
      if(debug>0){
	cout<<"Ecriture de "<<nom<<" ...";
	fflush(stdout);
      }
#endif
      
      
      
      // ECRITURE DE L'ENTETE PGM
      // =========================
      fprintf(f,"P5\x0A");					// marque PGM
      
      // ecrit lignes de commentaire non-vides
      if( commentaire[0] !='\0' )	fprintf(f,"# %s\x0A",commentaire);
      if( commentaire2[0]!='\0' )	fprintf(f,"# %s\x0A",commentaire2);
      if( commentaire3[0]!='\0' )	fprintf(f,"# %s\x0A",commentaire3);
      
      fprintf(f,"%d %d\x0A", MonImage.dim2, MonImage.dim1);			// dimensions
      if( sizeof(Type)==1 )
	fprintf(f,"%d\x0A",255);				// niveau de gris maximum
      else fprintf(f,"%d bytes\x0A",(int)sizeof(Type));	// longueur des lments
      
  
      // ECRITURE DES ELEMENTS
      // =====================
      try_fwrite( (char*)&(MonImage.ptr2[MonImage.inf1][MonImage.inf2]),
		  sizeof(Type),MonImage.dim1*MonImage.dim2,f,nom);
      
#ifdef Msg_ES
      if(debug>0){
	cout<<"  terminee."<<endl;
	fflush(stdout);
      }
#endif
      
      fclose(f);
  
    }
  
  
  // ***************************************************************************
  //  Entete + code, par octet, en ASCII (P3) ou binaire (P6)
  //  
  void charge_pnm(Tab<ip_ColorElement8u> & MonImage, char* nom,int debug=0);

  inline void charge_ppm(Tab<ip_ColorElement8u> & MonImage, char* nom,int debug=0){
    charge_pnm(MonImage,nom,debug);
  }

  inline void charge_pnm(Tab<octet> & MonImage, char* nom,int debug=0){
    Tab<ip_ColorElement8u> Ic;
    int li,co;
    
    charge_pnm(Ic,nom,debug);
    MonImage.dimensionne(Ic.dim1,Ic.dim2);
    
    ForAllPts(MonImage,li,co)
      {
	RGBToGray(Ic(li,co).r,Ic(li,co).g,Ic(li,co).b,MonImage(li,co));
      }
  }
  
  
  void sauve_pnm(Tab<ip_ColorElement8u> & MonImage,
		 char *nom,
		 int  P3=0, // defaut = pnm
		 int debug	   = 1,
		 //	 char *ext = "",
		 char *commentaire = "JMarc Odobez - Created by PNM-library",
		 char *commentaire2= "",
		 char *commentaire3= ""
		 );
  
  inline void sauve_ppm(Tab<ip_ColorElement8u> & MonImage,
			char *nom,
			int  P3=1, // defaut = ppm
			int debug	   = 1,
			//	 char *ext = "",
			char *commentaire = "JMarc Odobez - Created by PNM-library",
			char *commentaire2= "",
			char *commentaire3= ""
			)
    {
      sauve_pnm(MonImage,nom,P3,debug,commentaire,commentaire2,commentaire3);
    }
  
  

}

#endif	// MyLoadSaveImageT_HH

