#include <stdio.h>

#include "bf_DynamicModel.h"

#include "bf_MixedParticleDistribution.h"
#include "bf_DataRandomVariable.h"
#include "bf_ParticleFilter.h"
#include "bf_Trainer.h"

using namespace Torch;


/*
  [xk+1  xk] = A [xk  xk-1] + B nu

  A = [2 -1; 1 0] (A=Fx in implementation)   B = [1]

  nu = noise : variance sigma2;
*/

class MyPredictor : public bf_LinearPredictModelReal {

  public :
    bf_RandomGenerator   rng;

  public :
    MyPredictor(float sigma2=1.) : 
    bf_LinearPredictModelReal(2,1,&rng) {

    m_pRng=&rng;
    
    Fx.ptr[0][0]=2; Fx.ptr[0][1]=-1;
    Fx.ptr[1][0]=1; Fx.ptr[1][1]=0;

    G.ptr[0][0]=1;

    q.ptr[0]=sigma2;

  } 

  ~MyPredictor(){  }

};
//==========================================================
// My Data should be read from a file. Here we use a model to 
// generate them
// 
class MyData : virtual public bf_DataRandomVariable {
  
  public :
    real observation;
  real    w;
  real    wv;
  int iter;

  MyData(){ w=0.08; iter=0; addToData(&observation); }

  inline virtual void initData(){ 
    wv=w*(1+0.9*cos(iter*0.1));    observation=(real)(cos(wv*iter));
  }
  
  inline virtual void nextData(){ 
    iter++;
    wv=w*(1+0.9*cos(iter*0.1));    observation=(real)(cos(wv*iter));
  }

  inline virtual bool dataAvailable(){ return true; }

  ~MyData(){}
  
};

//==========================================================
// likelihood ( p(yk| [xk xk-1]) proportional to exp(-(yk-xk)^2 / (2*sigma2))
//   yk = data, x = [xk xk-1] = state 

class MyLikelihood : virtual public bf_EvalCondDistReal {

  public :
    real m_rCoef;

  MyLikelihood(real sigma2) : bf_EvalCondDistReal () {
    m_rCoef = 1./(2*sigma2);
  }

  // computing P ( X | Y ) : here first element of state is 
  virtual inline real evaluateConditionalReal(real *pX,real *pY){
    return exp(-m_rCoef*(*pX-*pY)*(*pX-*pY));
  }

  ~MyLikelihood(){}

};

//==========================================================

class MyTracker : public bf_Trainer {

  //-- members

 public:
  // for the particles
  bf_RandomGenerator                *m_pRng1;
  bf_RandomGenerator                *m_pRng2;
  bf_MixedParticleDistribution      *m_pPosteriorDistribution;  
  bf_MixedParticleDistribution      *m_pAuxDistribution;
  
  // for the dynamical model
  MyPredictor                       *m_pDynamics;

  // for the likelihood
  MyLikelihood                      *m_pLikelihood;

  // pointers to filter and data are inherited from the Trainer
  // nevertheless, here we declare a particle filter
  bf_ParticleFilter                 *m_pParticleFilter;

  MyTracker(bf_DataRandomVariable *pZ,int NberOfParticles,
	    real sigma2Dyn=1.,real sigma2Like=1.) : 
    bf_Trainer(NULL,pZ) {
    
    m_pRng1=new bf_RandomGenerator(3);
    m_pRng2=new bf_RandomGenerator(2);

    int  StateSize=2;
    m_pPosteriorDistribution=new bf_MixedParticleDistribution(NberOfParticles,1,StateSize,0,m_pRng1);  
    m_pAuxDistribution=new bf_MixedParticleDistribution(NberOfParticles,1,StateSize,0,m_pRng2);      

    m_pDynamics=new MyPredictor(sigma2Dyn);

    m_pLikelihood=new MyLikelihood(sigma2Like);

    m_pParticleFilter =new bf_ParticleFilter(m_pPosteriorDistribution,
					     m_pAuxDistribution,
					     m_pDynamics,m_pLikelihood); 
    m_pBayesFilter = m_pParticleFilter;
  }
  //--------
  void  init(long N=-1){
    bf_Trainer::init(N);

    real *initstate=new real [2];
    // initialization with the first data obervation available
    initstate[0]=m_pDataInput->m_cData.nodes[0][0];
    initstate[1]=m_pDataInput->m_cData.nodes[0][0];
    m_pPosteriorDistribution->setAllSample(initstate,0);
  }

  //--------
  ~MyTracker(){
    delete m_pDynamics;
    delete m_pRng1;    delete m_pRng2;
    delete m_pPosteriorDistribution;
    delete m_pAuxDistribution;
    delete m_pParticleFilter;
    delete m_pLikelihood;
  }


};
