#ifndef BICV_HISTOGRAM_TRACKER_INC
#define BICV_HISTOGRAM_TRACKER_INC

#include "general.h"

// open cv
#include "cv.h"

#include "bicv_HistogramLikelihood.h"
#include "bicv_ChessBoardTemplate.h"
#include "bf_MixedParticleDistribution.h"
#include "bf_Trainer.h"
#include "bf_DynamicAR.h"
#include "bf_ParticleFilter.h"

using namespace ImageProcessing;

namespace Torch {
  //-----

  /** 

     Particle filter that uses 
     - The "chess-board" object model as Histogram Likelihood
     - a planar Transform 
     - an AR dynamic
      
    
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  //===================================================
  //
  //
  //===================================================

  class   bicv_HistogramTracker : virtual public bf_Trainer  {

    //-- members

  public:
    // for the particles
    bf_RandomGenerator                *m_pRng1;
    bf_RandomGenerator                *m_pRng2;
    bf_MixedParticleDistribution      *m_pPosteriorDistribution;  
    bf_MixedParticleDistribution      *m_pAuxDistribution;

    // for the dynamical model
    bf_DynamicAR                      *m_pDynamics; 

    // for the histogram likelihood
    ip_PlanarTransform                *m_pTrans;
    ipcv_HistogramTemplate            *m_pTemplate;
    int                                m_iNumberOfBands;
    ip_BoundingBox                     m_cInitBB;
    bicv_ChessBoardTemplate           *m_pMeasurer;
    bf_EvalDistReal                   *m_pProbaLikelihood;
    bf_EvalCondDist                  **m_pLikelihoodTable;
    int                                m_iNumberOfLikelihood;
    //   bicv_HistogramLikelihood          *m_pLikelihood;
    bf_EvalCondDist                    *m_pLikelihood;


    // filter and data are inherited from the Trainer
    // nevertheless, here we declare a particle filter
    bf_ParticleFilter                 *m_pParticleFilter;

    //-- member functions
    
  public:

    //================================================================

    //-- constructors

    bicv_HistogramTracker(int NberOfParticles, ip_PlanarTransform *T,
			  int SplitHeight,int SplitWidth,
			  ip_BoundingBox   initBB,
			  int  DIM_C,
			  bf_DataRandomVariable *pZ,
			  real Lambda,real Z,
			  real DynamicsTranslationStdev,
			  real DynamicsAffineStdev,
			  int  number_of_bands=3);

    //================================================================

    // Initialisation
    virtual void init(long N=-1);


    //================================================================
    
    virtual ~bicv_HistogramTracker();

  };

   
}

#endif
